
package org.blufin.core.server.startup;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.blufin.base.helper.Pair;
import org.blufin.base.utils.UtilsEnvironment;
import org.blufin.core.cloud.queue.MessageQueueConfig;
import org.blufin.core.server.aws.AWSInstanceDataResolver;
import org.blufin.core.server.config.BaseConfig;
import org.blufin.core.slack.SlackChannels;
import org.blufin.core.slack.SlackClient;
import org.blufin.jackson.Jackson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Primary;
@ComponentScan("org.blufin.core.spring.core")
public abstract class AbstractApplication {
    @Autowired
    BaseConfig baseConfig;
    protected void init() {
        UtilsEnvironment.initialize(baseConfig.getEnvironment());
        AWSInstanceDataResolver.initialize(baseConfig.getEnvironment());
        MessageQueueConfig.initialize(Pair.of(baseConfig.getMessageQueueHost(), baseConfig.getMessageQueueName()));
        SlackClient.initialize(new SlackChannels(baseConfig.getSlackLogURL(), baseConfig.getSlackErrorsURL()));
    }
    @Bean
    @Primary
    public ObjectMapper objectMapper() {
        return Jackson.getNonNullObjectMapper();
    }
}
