
package org.blufin.core.slack;
import org.blufin.base.annotations.Singleton;
import org.blufin.base.annotations.TestOnly;
import org.blufin.base.interfaces.Initializable;
import org.blufin.core.http.HttpClient;
import org.blufin.core.http.HttpClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
@Deprecated
public class SlackClient extends Initializable<SlackChannels> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlackClient.class);
    private static SlackClient instance = new SlackClient();
    private boolean testEnvironment = false;
    private String logUrl;
    private String errorUrl;
    @Singleton
    private SlackClient() {}
    public static void initialize(SlackChannels slackChannels) {
        instance.initializeClass(slackChannels);
        instance.errorUrl = instance.getInitializationData().getErrorUrl();
    }
    @TestOnly
    public static void initializeForTest() {
        instance.testEnvironment = true;
    }
    public static void log(String message) {
        if (instance.testEnvironment) {
            System.out.println(message);
            return;
        }
        instance.postToSlack(message, instance.getLogUrl());
    }
    public static void error(String message) {
        if (instance.testEnvironment) {
            System.out.println(message);
            return;
        }
        instance.postToSlack(message, instance.getErrorUrl());
    }
    private void postToSlack(String message, String uri) {
        String payload = "{\"text\": \"" + message.replace("\"", "\\\"") + "\"}";
        HttpClientResponse response = HttpClient.postJsonString(uri, payload);
        if (response != null && response.getStatusCode() != 200) {
            LOGGER.error("SlackClient failed to post w/error: " + response.getStatusCode() + " - " + response.getStatusText() + " - " + response.getBody());
            LOGGER.error("SlackClient payload: " + payload);
        }
    }
    private String getLogUrl() {
        if (logUrl == null) {
            logUrl = getInitializationData().getLogUrl();
        }
        return logUrl;
    }
    private String getErrorUrl() {
        if (errorUrl == null) {
            errorUrl = getInitializationData().getErrorUrl();
        }
        return errorUrl;
    }
}
