
package org.blufin.core.slack;
import org.blufin.base.interfaces.Initializable;
import org.blufin.base.utils.UtilsLogger;
import org.blufin.core.http.HttpClient;
import org.blufin.core.http.HttpClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Map;
@Deprecated
public class SlackClientDeprecated extends Initializable<Map<String, String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlackClientDeprecated.class);
    public static final String DEBUG_URI = "DEBUG_URI";
    public static final String ERROR_URI = "ERROR_URI";
    public static final String HITS_URI = "HITS_URI";
    public static final String TICKER_URI = "TICKER_URI";
    private String slackDebugUri;
    private String slackErrorUri;
    private String slackHitsUri;
    private String slackTickerUri;
    private static SlackClientDeprecated instance = new SlackClientDeprecated();
    private SlackClientDeprecated() {}
    public static SlackClientDeprecated getInstance() {
        return instance;
    }
    public void postDebugAlert(String message) {
        try {
            postAlert(message, getSlackDebugUri(), "Debug", "slack");
        } catch (Exception e) {
            UtilsLogger.error("Failed to post Slack \"Debug\" alert.", e);
        }
    }
    public void postErrorAlert(String message) {
        try {
            postAlert(message, getSlackErrorUri(), "Error", "slack");
        } catch (Exception e) {
            UtilsLogger.error("Failed to post Slack \"Error\" alert.", e);
        }
    }
    public void postHitAlert(String message) {
        try {
            postAlert(message, getSlackHitsUri(), "Hit", "slack");
        } catch (Exception e) {
            UtilsLogger.error("Failed to post Slack \"Hit\" alert.", e);
        }
    }
    public void postTickerAlert(String message) {
        try {
            postAlert(message, getSlackTickerUri(), "SlackTicker", "slack");
        } catch (Exception e) {
            UtilsLogger.error("Failed to post Slack \"Ticker\" alert.", e);
        }
    }
    private void postAlert(String message, String uri, String botName, String botIcon) {
        String jsonString = "{\"username\": \"" + botName + "\", \"icon_emoji\": \"" + botIcon + "\", \"text\": \"" + message.replace("\"", "\\\"") + "\"}";
        HttpClientResponse response = HttpClient.postJsonString(uri, jsonString);
        if (response != null && response.getStatusCode() != 200) {
            LOGGER.error("SlackClientDeprecated failed to post: " + response.getStatusCode() + " - " + response.getStatusText() + " - " + response.getBody());
            LOGGER.error("JSON String:\n\n" + jsonString + "\n");
        }
    }
    private String getSlackDebugUri() {
        if (slackDebugUri == null) {
            slackDebugUri = getInitializationData().get(DEBUG_URI);
        }
        return slackDebugUri;
    }
    private String getSlackErrorUri() {
        if (slackErrorUri == null) {
            slackErrorUri = getInitializationData().get(ERROR_URI);
        }
        return slackErrorUri;
    }
    private String getSlackHitsUri() {
        if (slackHitsUri == null) {
            slackHitsUri = getInitializationData().get(HITS_URI);
        }
        return slackHitsUri;
    }
    private String getSlackTickerUri() {
        if (slackTickerUri == null) {
            slackTickerUri = getInitializationData().get(TICKER_URI);
        }
        return slackTickerUri;
    }
}
