
package org.blufin.core.slack;
import org.blufin.base.interfaces.Initializable;
import org.blufin.base.utils.UtilsLogger;
import java.util.Calendar;
@Deprecated
public class SlackTicker extends Initializable<Boolean> {
    private static final SlackTicker instance = new SlackTicker();
    private SlackTicker() {}
    public static SlackTicker getInstance() {
        return instance;
    }
    @Deprecated
    public void emit(SlackTickerMessage slackTickerMessage) {
        try {
            StringBuilder slackMessageBuilder = new StringBuilder();
            if (slackTickerMessage.getTimestamp() != null) {
                slackMessageBuilder.append(UtilsLogger.ANSI_YELLOW).append(getTimeFormatted(slackTickerMessage.getTimestamp())).append(UtilsLogger.ANSI_RESET + " → ");
            }
            if (slackTickerMessage.getTitle() != null) {
                slackMessageBuilder.append(UtilsLogger.ANSI_GREEN).append(slackTickerMessage.getTitle()).append(UtilsLogger.ANSI_RESET);
            } else if (slackTickerMessage.getTitleNoFormat() != null) {
                slackMessageBuilder.append(slackTickerMessage.getTitleNoFormat());
            }
            if (slackTickerMessage.getBodyWithNoBreak() != null) {
                slackMessageBuilder.append(slackTickerMessage.getTitle() == null ? "" : " ").append(slackTickerMessage.getBodyWithNoBreak());
            }
            if (slackTickerMessage.getBody() != null) {
                slackMessageBuilder.append(slackTickerMessage.getBody());
            }
            if (slackTickerMessage.getPayload() != null) {
                slackMessageBuilder.append(UtilsLogger.ANSI_GRAY).append(slackTickerMessage.getPayload()).append(UtilsLogger.ANSI_RESET);
            }
            if (slackTickerMessage.getFooter() != null) {
                slackMessageBuilder.append(UtilsLogger.ANSI_PURPLE).append(slackTickerMessage.getFooter()).append(UtilsLogger.ANSI_RESET);
            }
            String slackMessage = slackMessageBuilder.toString();
        } catch (Exception e) {
            UtilsLogger.error("Failed to post Slack \"Ticker\" message", e);
        }
    }
    private final String getTimeFormatted(Calendar timestamp) {
        return "00:00:00";
    }
}
