
package org.blufin.core.utils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.blufin.base.utils.UtilsLogger;
import org.apache.commons.codec.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
public class UtilsFile {
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static List<String> getFilesInDir(String directory) {
        List<String> files = new ArrayList<>();
        try {
            File folder = new File(directory);
            File[] filesInFolder = folder.listFiles();
            if (filesInFolder != null) {
                for (final File fileEntry : filesInFolder) {
                    if (!fileEntry.isDirectory()) {
                        files.add(fileEntry.getName());
                    }
                }
                Collections.sort(files);
            }
        } catch (NullPointerException e) {
            UtilsLogger.error("Directory '" + directory + "' not found in: '" + System.getProperty("user.dir") + "'", e);
        }
        return files;
    }
    @SuppressFBWarnings(value = "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE", justification = "In this case, it's cool :)")
    public static boolean writeStringToFile(String fullPathToFile, String content) {
        try {
            Path path = Paths.get(fullPathToFile);
            if (!directoryExists(path.getParent().toString())) {
                Files.createDirectories(path.getParent());
            }
            if (!fileExists(fullPathToFile)) {
                Files.createFile(path);
            }
            Files.write(Paths.get(fullPathToFile), content.getBytes(Charsets.UTF_8), StandardOpenOption.WRITE);
            return true;
        } catch (Exception e) {
            UtilsLogger.error("Something went wrong trying to write file: '" + fullPathToFile + "'", e);
            return false;
        }
    }
    public static List<String> readLinesOfFileAsArray(String fullPathToFile) {
        List<String> lines = new ArrayList<>();
        try {
            lines = Files.readAllLines(Paths.get(fullPathToFile));
        } catch (IOException e) {
            UtilsLogger.error("Something went wrong trying to read file as array of lines: " + fullPathToFile, e);
        }
        return lines;
    }
    public static String readLinesOfFileAsString(String fullPathToFile) {
        StringBuilder contentBuilder = new StringBuilder();
        try {
            for (String line : Files.readAllLines(Paths.get(fullPathToFile))) {
                contentBuilder.append(line).append(NEW_LINE);
            }
        } catch (IOException e) {
            UtilsLogger.error("Something went wrong trying to read file as string: " + fullPathToFile, e);
        }
        return contentBuilder.toString();
    }
    public static boolean createDirectory(String fullPathToDirectory) {
        boolean result = false;
        try {
            result = new File(fullPathToDirectory).mkdirs();
            if (!result) {
                throw new Exception();
            }
        } catch (Exception e) {
            UtilsLogger.error("Failed to create directory: " + fullPathToDirectory);
        }
        return result;
    }
    public static boolean deleteDirectory(String fullPathToDirectory) {
        boolean result = false;
        try {
            File directory = new File(fullPathToDirectory);
            if (!directory.isDirectory()) {
                throw new Exception("Cannot delete directory because not a directory: " + fullPathToDirectory);
            }
            result = directory.delete();
            if (!result) {
                throw new Exception();
            }
        } catch (Exception e) {
            UtilsLogger.error("Failed to delete directory: " + fullPathToDirectory, e);
        }
        return result;
    }
    public static boolean fileExists(String fullPathToFile) {
        File file = new File(fullPathToFile);
        return (file.exists() && !file.isDirectory());
    }
    public static boolean directoryExists(String fullPathToFile) {
        File file = new File(fullPathToFile);
        return (file.exists() && file.isDirectory());
    }
}
