
package org.blufin.core.utils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
public class UtilsGenerics {
    private static <T> Class<T> determineClass(Class<? super T> bound, Type candidate) {
        if (candidate instanceof Class<?>) {
            final Class<?> cls = (Class<?>) candidate;
            if (bound.isAssignableFrom(cls)) {
                return (Class<T>) cls;
            }
        }
        return null;
    }
    public static <T> Class<T> getTypeParameter(Class<?> clazz, Class<? super T> bound) {
        Type type = clazz;
        while (type instanceof Class<?>) {
            type = ((Class<?>) type).getGenericSuperclass();
        }
        if (type instanceof ParameterizedType) {
            for (Type param : ((ParameterizedType) type).getActualTypeArguments()) {
                if (param instanceof Class<?>) {
                    final Class<T> cls = determineClass(bound, param);
                    if (cls != null) {
                        return cls;
                    }
                } else if (param instanceof TypeVariable) {
                    for (Type paramBound : ((TypeVariable<?>) param).getBounds()) {
                        if (paramBound instanceof Class<?>) {
                            final Class<T> cls = determineClass(bound, paramBound);
                            if (cls != null) {
                                return cls;
                            }
                        }
                    }
                }
            }
        }
        throw new IllegalStateException("Cannot reliably determine type parameterization for: " + clazz.getName());
    }
    public static Class<?> getTypeParameter(Class<?> clazz) {
        return getTypeParameter(clazz, Object.class);
    }
}
