
package org.blufin.core.utils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
public class UtilsHTML {
    public static String unEscapeHTML(String rawHTML) {
        if (rawHTML == null) {
            return StringUtils.EMPTY;
        }
        rawHTML = StringEscapeUtils.unescapeHtml4(rawHTML);
        rawHTML = StringEscapeUtils.unescapeXml(rawHTML);
        return rawHTML;
    }
    public static String removeHTMLTags(String rawHTML) {
        if (rawHTML == null) {
            return StringUtils.EMPTY;
        }
        return rawHTML.replaceAll("<(/)?[a-zA-Z-]{1,24}(/)?>", "");
    }
}
