
package org.blufin.core.utils;
import org.json.JSONArray;
import org.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
public class UtilsJson {
    public static HashMap<String, String> convertJsonToHashMap(String jsonString) throws Exception {
        HashMap<String, String> map = new HashMap();
        JSONObject jObject = new JSONObject(jsonString);
        Iterator<?> keys = jObject.keys();
        while (keys.hasNext()) {
            String key = (String) keys.next();
            String value = jObject.getString(key);
            map.put(key, value);
        }
        return map;
    }
    public static List<String> convertJsonToArrayList(String jsonString) throws Exception {
        List<String> list = new ArrayList<>();
        JSONArray jArray = new JSONArray(jsonString);
        if (jArray != null) {
            for (int i = 0; i < jArray.length(); i++) {
                list.add(jArray.get(i).toString());
            }
        }
        return list;
    }
    public static List<Map<String, String>> convertJsonToArrayListOfHashes(String jsonString) throws Exception {
        List<Map<String, String>> list = new ArrayList<>();
        List<String> hashes = convertJsonToArrayList(jsonString);
        for (String hash : hashes) {
            list.add(convertJsonToHashMap(hash));
        }
        return list;
    }
    public static String getFirstKey(HashMap<String, String> hashMap) {
        Map.Entry<String, String> entry = hashMap.entrySet().iterator().next();
        return entry.getKey();
    }
    public static String getFirstValue(HashMap<String, String> hashMap) {
        Map.Entry<String, String> entry = hashMap.entrySet().iterator().next();
        return entry.getValue();
    }
}
