
package org.blufin.core.utils;
import org.blufin.base.utils.UtilsLogger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
public class UtilsSoap {
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
    public static XMLStreamReader getXMLStream(String rawSoapXML) {
        try {
            InputStream byteStream = new ByteArrayInputStream(rawSoapXML.getBytes(StandardCharsets.UTF_8));
            return xmlInputFactory.createXMLStreamReader(byteStream);
        } catch (XMLStreamException e) {
            UtilsLogger.error("Failed to get XMLStreamReader from SOAP XML String.", rawSoapXML, e);
        }
        return null;
    }
    public static XMLStreamReader getXMLStreamForStartElement(String rawSoapXML, String nodeName) {
        try {
            XMLStreamReader xmlStream = getXMLStream(rawSoapXML);
            if (xmlStream != null) {
                while (xmlStream.hasNext()) {
                    if (xmlStream.next() == XMLEvent.START_ELEMENT) {
                        if (nodeName.equals(xmlStream.getLocalName())) {
                            return xmlStream;
                        }
                    }
                }
            }
        } catch (XMLStreamException e) {
            UtilsLogger.error("Failed to find node '" + nodeName + "' in SOAP XML String -- returned NULL instead of XMLStreamReader.", rawSoapXML, e);
        }
        return null;
    }
    public static List<String> getValueForNodeName(String rawSoapXML, String nodeName) {
        List<String> valuesForNodeNames = new ArrayList<>();
        try {
            XMLStreamReader xmlStream = getXMLStream(rawSoapXML);
            if (xmlStream != null) {
                while (xmlStream.hasNext()) {
                    if (xmlStream.next() == XMLEvent.START_ELEMENT) {
                        if (nodeName.equals(xmlStream.getLocalName())) {
                            xmlStream.next();
                            valuesForNodeNames.add(xmlStream.getText());
                        }
                    }
                }
            }
        } catch (Exception e) {
            UtilsLogger.error("Failed to get value(s) for node name: " + nodeName, rawSoapXML, e);
        }
        return valuesForNodeNames;
    }
}
