
package org.blufin.core.utils;
import org.blufin.base.utils.UtilsLogger;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
public class UtilsValidation {
    public static <T> ArrayList<String> validatePropertiesAreNotNull(T object) {
        ArrayList<String> nullProperties = new ArrayList<>();
        for (Field field : object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object value = field.get(object);
                if (value == null) {
                    nullProperties.add(field.getName());
                }
            } catch (IllegalAccessException e) {
                UtilsLogger.error(MessageFormat.format("Failed to iterate property values of {0}.", object.getClass().getName()), e);
            }
        }
        return nullProperties;
    }
}
