/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.auth.client;

import java.text.MessageFormat;
import org.blufin.base.enums.TimeZone;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.core.auth.client.ClientDataFactory;
import org.blufin.sdk.embedded.dto.app.EmbeddedUser;
import org.blufin.sdk.embedded.dto.common.EmbeddedAccount;
import org.blufin.sdk.embedded.dto.common.EmbeddedThirdPartyApplication;

public abstract class ClientData {
    public static final EmbeddedUser getUser() {
        return ClientDataFactory.getClientData().getUser();
    }

    public static final EmbeddedAccount getAccount() {
        return ClientDataFactory.getClientData().getAccount();
    }

    public static final EmbeddedThirdPartyApplication getThirdPartyApplication() {
        return ClientDataFactory.getClientData().getThirdPartyApplication();
    }

    public static final TimeZone getTimeZone() {
        if (!ClientDataFactory.hasClientDataAccount() && !ClientDataFactory.hasClientDataUser()) {
            return TimeZone.UTC;
        }
        if (ClientDataFactory.hasClientDataUser() && ClientDataFactory.getClientData().getUser().getTimeZone() != null) {
            return ClientDataFactory.getClientData().getUser().getTimeZone();
        }
        if (!ClientDataFactory.hasClientDataAccount() || ClientDataFactory.getClientData().getAccount().getTimeZone() == null) {
            int accountId = ClientDataFactory.getClientData().getAccount().getId();
            int userId = ClientDataFactory.getClientData().getUser().getId();
            throw new BlufinAlertDeveloperException(MessageFormat.format("TimeZone for both the Account (ID: {0}) and User (ID: {1}) were NULL. This should never happen.", accountId, userId));
        }
        return ClientDataFactory.getClientData().getAccount().getTimeZone();
    }
}

