/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.auth.client;

import org.blufin.core.auth.enums.AuthMethod;
import org.blufin.sdk.base.AbstractClientData;
import org.blufin.sdk.embedded.dto.app.EmbeddedUser;
import org.blufin.sdk.embedded.dto.common.EmbeddedAccount;
import org.blufin.sdk.embedded.dto.common.EmbeddedThirdPartyApplication;

public final class ClientDataContainer<U extends EmbeddedUser, A extends EmbeddedAccount, O extends EmbeddedThirdPartyApplication>
implements AbstractClientData<U, A, O> {
    public static final int SYSTEM_USER = 0;
    private final AuthMethod authMethod;
    private final String ipAddress;
    private final A account;
    private final U user;
    private final O thirdPartyApplication;

    public ClientDataContainer(String accountName) {
        this.authMethod = null;
        this.ipAddress = null;
        this.user = null;
        this.thirdPartyApplication = null;
        this.account = new EmbeddedAccount();
        this.account.setAccountName(accountName);
    }

    public ClientDataContainer(AuthMethod authMethod, String ipAddress) {
        this.authMethod = authMethod;
        this.ipAddress = ipAddress;
        this.account = null;
        this.user = null;
        this.thirdPartyApplication = null;
    }

    public ClientDataContainer(AuthMethod authMethod, String ipAddress, A account) {
        this.authMethod = authMethod;
        this.ipAddress = ipAddress;
        this.account = account;
        this.user = null;
        this.thirdPartyApplication = null;
    }

    public ClientDataContainer(AuthMethod authMethod, String ipAddress, A account, U user) {
        this.authMethod = authMethod;
        this.ipAddress = ipAddress;
        this.account = account;
        this.user = user;
        this.thirdPartyApplication = null;
    }

    public ClientDataContainer(AuthMethod authMethod, String ipAddress, O thirdPartyApplication, A account) {
        this.authMethod = authMethod;
        this.ipAddress = ipAddress;
        this.account = account;
        this.user = null;
        this.thirdPartyApplication = thirdPartyApplication;
    }

    public ClientDataContainer(AuthMethod authMethod, String ipAddress, O thirdPartyApplication, A account, U user) {
        this.authMethod = authMethod;
        this.ipAddress = ipAddress;
        this.account = account;
        this.user = user;
        this.thirdPartyApplication = thirdPartyApplication;
    }

    public AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public A getAccount() {
        return this.account;
    }

    public U getUser() {
        return this.user;
    }

    public O getThirdPartyApplication() {
        return this.thirdPartyApplication;
    }
}

