/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.auth.client;

import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.core.auth.client.ClientDataContainer;
import org.blufin.core.auth.client.ClientDataThreadLocal;

public final class ClientDataFactory {
    public static void setClientData(ClientDataContainer clientDataContainer) {
        ClientDataThreadLocal.setClientData(clientDataContainer);
    }

    public static ClientDataContainer getClientData() {
        ClientDataContainer clientDataContainer = ClientDataThreadLocal.getClientData();
        if (clientDataContainer == null) {
            String accountName = ClientDataThreadLocal.getAccount();
            if (accountName != null) {
                return new ClientDataContainer(accountName);
            }
            throw new BlufinAlertDeveloperException("Attempted to get " + ClientDataContainer.class.getSimpleName() + " from " + ClientDataFactory.class.getSimpleName() + " but it was not set in ThreadLocal<> context.");
        }
        return clientDataContainer;
    }

    public static void removeClientData() {
        ClientDataThreadLocal.removeClientData();
    }

    public static void setAccount(String clientAccount) {
        ClientDataThreadLocal.setAccount(clientAccount);
    }

    public static String getAccount() {
        String clientAccount = ClientDataThreadLocal.getAccount();
        if (clientAccount == null) {
            throw new BlufinAlertDeveloperException("Attempted to access Account (String)  from " + ClientDataFactory.class.getSimpleName() + " but it was not set in ThreadLocal<> context.");
        }
        return clientAccount;
    }

    public static void removeAccount() {
        if (ClientDataThreadLocal.getAccount() != null) {
            ClientDataThreadLocal.removeAccount();
        }
    }

    public static boolean hasClientData() {
        return ClientDataThreadLocal.getClientData() != null;
    }

    public static boolean hasClientDataAccount() {
        if (ClientDataThreadLocal.getClientData() != null) {
            return ClientDataThreadLocal.getClientData().getAccount() != null;
        }
        return false;
    }

    public static boolean hasClientDataUser() {
        if (ClientDataThreadLocal.getClientData() != null) {
            return ClientDataThreadLocal.getClientData().getUser() != null;
        }
        return false;
    }
}

