/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.auth.core;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.base.exceptions.BlufinServerException;
import org.blufin.core.auth.annotations.Public;
import org.blufin.core.auth.annotations.Secured;
import org.blufin.core.auth.annotations.helper.BY;
import org.blufin.core.auth.client.ClientDataContainer;
import org.blufin.core.auth.client.ClientDataFactory;
import org.blufin.core.auth.core.AuthMethodInvoker;
import org.blufin.core.auth.core.AuthMethodResolver;
import org.blufin.core.auth.data.ControllerAnnotations;
import org.blufin.core.auth.data.RequestHeaders;
import org.blufin.core.auth.enums.AuthMethod;
import org.blufin.core.auth.exceptions.AuthenticationException;
import org.blufin.core.auth.exceptions.UnmetHeaderRequisiteException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class AuthInterceptor {
    @Autowired
    AuthMethodInvoker authMethodInvoker;

    @Around(value="@annotation(org.blufin.core.auth.annotations.Secured)")
    public Object authenticate(ProceedingJoinPoint pjp) throws BlufinServerException, AuthenticationException {
        try {
            Optional<Object> clientDataOptional;
            ControllerAnnotations controllerAnnotations = this.getControllerAnnotations(pjp);
            RequestHeaders requestHeaders = this.getRequestHeaders();
            try {
                AuthMethod authMethod = AuthMethodResolver.resolve(requestHeaders, controllerAnnotations);
                clientDataOptional = this.authMethodInvoker.invoke(authMethod, requestHeaders);
                ClientDataFactory.removeAccount();
            }
            catch (UnmetHeaderRequisiteException e) {
                clientDataOptional = Optional.empty();
            }
            if (clientDataOptional.isPresent()) {
                ClientDataFactory.setClientData((ClientDataContainer)clientDataOptional.get());
                return pjp.proceed();
            }
            throw new AuthenticationException();
        }
        catch (AuthenticationException bae) {
            throw new AuthenticationException();
        }
        catch (Throwable t) {
            throw new BlufinServerException(t);
        }
    }

    private ControllerAnnotations getControllerAnnotations(ProceedingJoinPoint pjp) {
        Secured securedAnnotation;
        ControllerAnnotations controllerAnnotations = new ControllerAnnotations();
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        if (method.getAnnotation(Public.class) != null) {
            controllerAnnotations.setPubliclyAccessible(true);
        }
        if ((securedAnnotation = method.getAnnotation(Secured.class)) != null) {
            block4: for (BY by : securedAnnotation.value()) {
                switch (by) {
                    case ACCOUNT: {
                        controllerAnnotations.setSecured(true);
                        controllerAnnotations.setAccountAware(true);
                        continue block4;
                    }
                    case USER: {
                        controllerAnnotations.setSecured(true);
                        controllerAnnotations.setUserAware(true);
                        continue block4;
                    }
                    default: {
                        throw new BlufinAlertDeveloperException(MessageFormat.format("Unrecognized {0} value: {1}", BY.class.getSimpleName(), by.toString()));
                    }
                }
            }
        }
        return controllerAnnotations;
    }

    private RequestHeaders getRequestHeaders() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            headerMap.put(key, value);
        }
        return new RequestHeaders(headerMap);
    }
}

