/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.auth.core;

import java.text.MessageFormat;
import java.util.Optional;
import org.blufin.base.interfaces.Initializable;
import org.blufin.core.auth.client.ClientDataContainer;
import org.blufin.core.auth.data.RequestHeaders;
import org.blufin.core.auth.enums.AuthMethod;
import org.blufin.core.auth.exceptions.AuthenticationException;
import org.blufin.core.auth.handlers.ClientOriginatingAccountHandler;
import org.blufin.core.auth.handlers.ClientOriginatingAccountUserHandler;
import org.blufin.core.auth.handlers.InternalAccountHandler;
import org.blufin.core.auth.handlers.InternalAccountUserHandler;
import org.blufin.core.auth.handlers.InternalHandler;
import org.blufin.core.auth.handlers.OAuthAccountHandler;
import org.blufin.core.auth.handlers.OAuthAccountUserHandler;
import org.blufin.core.auth.handlers.PublicHandler;
import org.blufin.core.server.config.ApiConfig;
import org.blufin.sdk.embedded.base.EmbeddedSDK;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthMethodInvoker
extends Initializable<Boolean> {
    @Autowired
    EmbeddedSDK embeddedSDK;
    private PublicHandler publicHandler;
    private InternalHandler internalHandler;
    private InternalAccountHandler internalAccountHandler;
    private InternalAccountUserHandler internalAccountUserHandler;
    private OAuthAccountHandler oAuthAccountHandler;
    private OAuthAccountUserHandler oAuthAccountUserHandler;
    private ClientOriginatingAccountHandler clientOriginatingAccountHandler;
    private ClientOriginatingAccountUserHandler clientOriginatingAccountUserHandler;

    public final Optional<ClientDataContainer> invoke(AuthMethod authMethod, RequestHeaders requestHeaders) {
        try {
            ClientDataContainer clientDataContainer;
            switch (authMethod) {
                case NONE: {
                    clientDataContainer = this.publicHandler.authenticate(requestHeaders);
                    break;
                }
                case INTERNAL: {
                    clientDataContainer = this.internalHandler.authenticate(requestHeaders);
                    break;
                }
                case INTERNAL_ACCOUNT: {
                    clientDataContainer = this.internalAccountHandler.authenticate(requestHeaders);
                    break;
                }
                case INTERNAL_ACCOUNT_USER: {
                    clientDataContainer = this.internalAccountUserHandler.authenticate(requestHeaders);
                    break;
                }
                case CLIENT_ORIGINATING_ACCOUNT: {
                    clientDataContainer = this.clientOriginatingAccountHandler.authenticate(requestHeaders);
                    break;
                }
                case CLIENT_ORIGINATING_ACCOUNT_USER: {
                    clientDataContainer = this.clientOriginatingAccountUserHandler.authenticate(requestHeaders);
                    break;
                }
                case OAUTH_ACCOUNT: {
                    clientDataContainer = this.oAuthAccountHandler.authenticate(requestHeaders);
                    break;
                }
                case OAUTH_ACCOUNT_USER: {
                    clientDataContainer = this.oAuthAccountUserHandler.authenticate(requestHeaders);
                    break;
                }
                default: {
                    throw new AuthenticationException(MessageFormat.format("Unhandled AuthMethod: {0}", authMethod.toString()));
                }
            }
            return clientDataContainer == null ? Optional.empty() : Optional.of(clientDataContainer);
        }
        catch (AuthenticationException e) {
            return Optional.empty();
        }
    }

    public void init(ApiConfig apiConfig) {
        this.initializeClass(true);
        if (apiConfig.getAuthorizationLevel().getAuthMethods().contains((Object)AuthMethod.NONE)) {
            this.publicHandler = new PublicHandler();
        }
        if (apiConfig.getAuthorizationLevel().getAuthMethods().contains((Object)AuthMethod.INTERNAL)) {
            this.internalHandler = new InternalHandler(apiConfig.getAuthorizationHeader());
        }
        if (apiConfig.getAuthorizationLevel().getAuthMethods().contains((Object)AuthMethod.INTERNAL_ACCOUNT)) {
            this.internalAccountHandler = new InternalAccountHandler(apiConfig.getAuthorizationHeader(), this.embeddedSDK.getEmbeddedAccountService());
        }
        if (apiConfig.getAuthorizationLevel().getAuthMethods().contains((Object)AuthMethod.INTERNAL_ACCOUNT_USER)) {
            this.internalAccountUserHandler = new InternalAccountUserHandler(apiConfig.getAuthorizationHeader(), this.embeddedSDK.getEmbeddedAccountService(), this.embeddedSDK.getEmbeddedUserService());
        }
        if (apiConfig.getAuthorizationLevel().getAuthMethods().contains((Object)AuthMethod.OAUTH_ACCOUNT)) {
            this.oAuthAccountHandler = new OAuthAccountHandler(this.embeddedSDK.getEmbeddedThirdPartyDeveloperService(), this.embeddedSDK.getEmbeddedThirdPartyApplicationService(), this.embeddedSDK.getEmbeddedAccountService());
        }
        if (apiConfig.getAuthorizationLevel().getAuthMethods().contains((Object)AuthMethod.OAUTH_ACCOUNT_USER)) {
            this.oAuthAccountUserHandler = new OAuthAccountUserHandler(this.embeddedSDK.getEmbeddedThirdPartyDeveloperService(), this.embeddedSDK.getEmbeddedThirdPartyApplicationService(), this.embeddedSDK.getEmbeddedAccountService(), this.embeddedSDK.getEmbeddedUserService());
        }
        if (apiConfig.getAuthorizationLevel().getAuthMethods().contains((Object)AuthMethod.CLIENT_ORIGINATING_ACCOUNT)) {
            this.clientOriginatingAccountHandler = new ClientOriginatingAccountHandler(apiConfig.getAuthorizationHeader(), this.embeddedSDK.getEmbeddedAccountService());
        }
        if (apiConfig.getAuthorizationLevel().getAuthMethods().contains((Object)AuthMethod.CLIENT_ORIGINATING_ACCOUNT_USER)) {
            this.clientOriginatingAccountUserHandler = new ClientOriginatingAccountUserHandler(apiConfig.getAuthorizationHeader(), this.embeddedSDK.getEmbeddedAccountService(), this.embeddedSDK.getEmbeddedUserService());
        }
    }

    public EmbeddedSDK getEmbeddedSDK() {
        return this.embeddedSDK;
    }

    public PublicHandler getPublicHandler() {
        return this.publicHandler;
    }

    public InternalHandler getInternalHandler() {
        return this.internalHandler;
    }

    public InternalAccountHandler getInternalAccountHandler() {
        return this.internalAccountHandler;
    }

    public InternalAccountUserHandler getInternalAccountUserHandler() {
        return this.internalAccountUserHandler;
    }

    public OAuthAccountHandler getOAuthAccountHandler() {
        return this.oAuthAccountHandler;
    }

    public OAuthAccountUserHandler getOAuthAccountUserHandler() {
        return this.oAuthAccountUserHandler;
    }

    public ClientOriginatingAccountHandler getClientOriginatingAccountHandler() {
        return this.clientOriginatingAccountHandler;
    }

    public ClientOriginatingAccountUserHandler getClientOriginatingAccountUserHandler() {
        return this.clientOriginatingAccountUserHandler;
    }
}

