/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.auth.data;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.blufin.core.auth.annotations.OAuth;
import org.blufin.core.auth.annotations.Public;
import org.blufin.core.auth.annotations.Secured;
import org.blufin.core.auth.annotations.helper.BY;

public class ControllerAnnotations {
    public static final String NO_ANNOTATIONS = "NONE";
    private boolean publiclyAccessible = false;
    private boolean secured = false;
    private boolean accountAware = false;
    private boolean userAware = false;
    private boolean oAuth = false;

    public String toString() {
        ArrayList<String> annotations = new ArrayList<String>();
        if (this.publiclyAccessible) {
            annotations.add(Public.class.getSimpleName());
        }
        if (this.secured) {
            annotations.add(Secured.class.getSimpleName());
        }
        if (this.accountAware) {
            annotations.add(BY.ACCOUNT.toString());
        }
        if (this.userAware) {
            annotations.add(BY.USER.toString());
        }
        if (this.oAuth) {
            annotations.add(OAuth.class.getSimpleName());
        }
        if (annotations.size() < 1) {
            annotations.add(NO_ANNOTATIONS);
        }
        return StringUtils.join(annotations, (String)"-");
    }

    public boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public boolean isAccountAware() {
        return this.accountAware;
    }

    public boolean isUserAware() {
        return this.userAware;
    }

    public boolean isOAuth() {
        return this.oAuth;
    }

    public void setPubliclyAccessible(boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public void setAccountAware(boolean accountAware) {
        this.accountAware = accountAware;
    }

    public void setUserAware(boolean userAware) {
        this.userAware = userAware;
    }

    public void setOAuth(boolean oAuth) {
        this.oAuth = oAuth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ControllerAnnotations)) {
            return false;
        }
        ControllerAnnotations other = (ControllerAnnotations)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPubliclyAccessible() != other.isPubliclyAccessible()) {
            return false;
        }
        if (this.isSecured() != other.isSecured()) {
            return false;
        }
        if (this.isAccountAware() != other.isAccountAware()) {
            return false;
        }
        if (this.isUserAware() != other.isUserAware()) {
            return false;
        }
        return this.isOAuth() == other.isOAuth();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ControllerAnnotations;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPubliclyAccessible() ? 79 : 97);
        result = result * 59 + (this.isSecured() ? 79 : 97);
        result = result * 59 + (this.isAccountAware() ? 79 : 97);
        result = result * 59 + (this.isUserAware() ? 79 : 97);
        result = result * 59 + (this.isOAuth() ? 79 : 97);
        return result;
    }

    public ControllerAnnotations() {
    }

    public ControllerAnnotations(boolean publiclyAccessible, boolean secured, boolean accountAware, boolean userAware, boolean oAuth) {
        this.publiclyAccessible = publiclyAccessible;
        this.secured = secured;
        this.accountAware = accountAware;
        this.userAware = userAware;
        this.oAuth = oAuth;
    }
}

