/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.auth.data;

import java.util.Map;
import org.blufin.sdk.enums.AuthHeader;

public class RequestHeaders {
    public static final String IP_HEADER = "X-Real-IP";
    private final String authInternal;
    private final String authAccountName;
    private final String authAccountUser;
    private final String authIdentifier;
    private final String authToken;
    private final String oAuthDev;
    private final String oAuthApp;
    private final String oAuthAccountUser;
    private final String oAuthAccountToken;
    private final String xRealIP;

    public RequestHeaders(Map<String, String> headers) {
        this.authInternal = headers.getOrDefault(AuthHeader.AUTH_INTERNAL.toString(), null);
        this.authAccountName = headers.getOrDefault(AuthHeader.AUTH_ACCOUNT_NAME.toString(), null);
        this.authAccountUser = headers.getOrDefault(AuthHeader.AUTH_ACCOUNT_USER.toString(), null);
        this.authIdentifier = headers.getOrDefault(AuthHeader.AUTH_IDENTIFIER.toString(), null);
        this.authToken = headers.getOrDefault(AuthHeader.AUTH_TOKEN.toString(), null);
        this.oAuthDev = headers.getOrDefault(AuthHeader.X_OAUTH_DEV.toString(), null);
        this.oAuthApp = headers.getOrDefault(AuthHeader.X_OAUTH_APP.toString(), null);
        this.oAuthAccountUser = headers.getOrDefault(AuthHeader.X_OAUTH_ACCOUNT_USER.toString(), null);
        this.oAuthAccountToken = headers.getOrDefault(AuthHeader.X_OAUTH_ACCOUNT_TOKEN.toString(), null);
        this.xRealIP = headers.getOrDefault(IP_HEADER, null);
    }

    public String getAuthInternal() {
        return this.authInternal;
    }

    public String getAuthAccountName() {
        return this.authAccountName;
    }

    public String getAuthAccountUser() {
        return this.authAccountUser;
    }

    public String getAuthIdentifier() {
        return this.authIdentifier;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getOAuthDev() {
        return this.oAuthDev;
    }

    public String getOAuthApp() {
        return this.oAuthApp;
    }

    public String getOAuthAccountUser() {
        return this.oAuthAccountUser;
    }

    public String getOAuthAccountToken() {
        return this.oAuthAccountToken;
    }

    public String getXRealIP() {
        return this.xRealIP;
    }
}

