/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.auth.handlers;

import java.text.MessageFormat;
import org.blufin.base.exceptions.BlufinNotImplementedException;
import org.blufin.core.auth.client.ClientDataContainer;
import org.blufin.core.auth.client.ClientDataFactory;
import org.blufin.core.auth.data.RequestHeaders;
import org.blufin.core.auth.enums.AuthMethod;
import org.blufin.core.auth.exceptions.AuthenticationException;
import org.blufin.sdk.embedded.dto.app.EmbeddedUser;
import org.blufin.sdk.embedded.dto.common.EmbeddedAccount;
import org.blufin.sdk.embedded.dto.common.EmbeddedThirdPartyApplication;
import org.blufin.sdk.embedded.refiner.EmbeddedAccountRefiner;
import org.blufin.sdk.embedded.refiner.EmbeddedThirdPartyApplicationRefiner;
import org.blufin.sdk.embedded.refiner.EmbeddedThirdPartyDeveloperRefiner;
import org.blufin.sdk.embedded.refiner.EmbeddedUserRefiner;
import org.blufin.sdk.embedded.service.EmbeddedAccountService;
import org.blufin.sdk.embedded.service.EmbeddedThirdPartyApplicationService;
import org.blufin.sdk.embedded.service.EmbeddedThirdPartyDeveloperService;
import org.blufin.sdk.embedded.service.EmbeddedUserService;
import org.blufin.sdk.enums.AuthHeader;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.response.ApiResponse;

public abstract class AbstractAuthenticationHandler {
    private String authorizationHeader;
    private EmbeddedThirdPartyDeveloperService thirdPartyDeveloperService;
    private EmbeddedThirdPartyApplicationService thirdPartyApplicationService;
    private EmbeddedAccountService accountService;
    private EmbeddedUserService userService;

    public abstract ClientDataContainer authenticate(RequestHeaders var1) throws Exception;

    protected EmbeddedThirdPartyApplication getThirdPartyApplication(String developerHash, String applicationHash) throws AuthenticationException {
        try {
            ApiResponse applicationApiResponse = ((PaginatedGetRequest)((EmbeddedThirdPartyApplicationRefiner)this.thirdPartyApplicationService.get().where()).hash().is(applicationHash)).entries(1).execute();
            if (applicationApiResponse.getPagination().getTotalEntries() != 1) {
                throw new AuthenticationException();
            }
            ApiResponse developerApiResponse = ((PaginatedGetRequest)((EmbeddedThirdPartyDeveloperRefiner)((PaginatedGetRequest)((EmbeddedThirdPartyDeveloperRefiner)this.thirdPartyDeveloperService.get().where()).id().is(((EmbeddedThirdPartyApplication)applicationApiResponse.getBody().get(0)).getThirdPartyDeveloperId().intValue())).where()).hash().is(developerHash)).entries(1).execute();
            if (developerApiResponse.getPagination().getTotalEntries() == 0) {
                throw new AuthenticationException();
            }
            return (EmbeddedThirdPartyApplication)applicationApiResponse.getBody().get(0);
        }
        catch (Exception e) {
            throw new RuntimeException(MessageFormat.format("Couldn''t resolve valid 3rd-Party application for header(s) {0}: {1} and {2}: {3}", AuthHeader.X_OAUTH_APP.toString(), applicationHash, AuthHeader.X_OAUTH_DEV.toString(), developerHash));
        }
    }

    protected EmbeddedAccount getAccount(String accountNameOrToken, AuthMethod authMethod) throws AuthenticationException {
        try {
            String accountName = this.getAccountName(accountNameOrToken, authMethod);
            try {
                ApiResponse apiResponse = ((PaginatedGetRequest)((EmbeddedAccountRefiner)this.accountService.get().where()).accountName().is(accountName)).entries(1).execute();
                ClientDataFactory.setAccount(((EmbeddedAccount)apiResponse.getBody().get(0)).getAccountName());
                return (EmbeddedAccount)apiResponse.getBody().get(0);
            }
            catch (Exception e) {
                throw new AuthenticationException(MessageFormat.format("Couldn''t resolve Account: {0}", accountName));
            }
        }
        catch (Exception e) {
            throw new AuthenticationException(e.getMessage());
        }
    }

    protected EmbeddedUser getUser(String accountNameOrToken, int userId, AuthMethod authMethod) throws AuthenticationException {
        try {
            String accountName = this.getAccountName(accountNameOrToken, authMethod);
            try {
                ApiResponse apiResponse = ((PaginatedGetRequest)((EmbeddedUserRefiner)((PaginatedGetRequest)this.userService.get().as(accountName)).where()).id().is(userId)).entries(1).execute();
                return (EmbeddedUser)apiResponse.getBody().get(0);
            }
            catch (Exception e) {
                throw new RuntimeException(MessageFormat.format("Couldn''t resolve valid User for Account: {0} and User ID: {1}", accountName, userId));
            }
        }
        catch (Exception e) {
            throw new AuthenticationException(e.getMessage());
        }
    }

    private String getAccountName(String accountNameOrToken, AuthMethod authMethod) throws AuthenticationException {
        switch (authMethod) {
            case INTERNAL_ACCOUNT: 
            case INTERNAL_ACCOUNT_USER: 
            case CLIENT_ORIGINATING_ACCOUNT: 
            case CLIENT_ORIGINATING_ACCOUNT_USER: {
                return accountNameOrToken;
            }
            case OAUTH_ACCOUNT: 
            case OAUTH_ACCOUNT_USER: {
                try {
                    throw new BlufinNotImplementedException();
                }
                catch (Exception e) {
                    throw new AuthenticationException(MessageFormat.format("Couldn''t resolve valid Account for header {0}: {1}", AuthHeader.X_OAUTH_ACCOUNT_TOKEN.toString(), accountNameOrToken));
                }
            }
        }
        throw new RuntimeException(MessageFormat.format("AuthMethod \u2192 {0} should never require an Account.", authMethod.toString()));
    }

    protected void setAuthorizationHeader(String authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
    }

    protected void setThirdPartyDeveloperService(EmbeddedThirdPartyDeveloperService thirdPartyDeveloperService) {
        this.thirdPartyDeveloperService = thirdPartyDeveloperService;
    }

    protected void setThirdPartyApplicationService(EmbeddedThirdPartyApplicationService thirdPartyApplicationService) {
        this.thirdPartyApplicationService = thirdPartyApplicationService;
    }

    protected void setAccountService(EmbeddedAccountService accountService) {
        this.accountService = accountService;
    }

    protected void setUserService(EmbeddedUserService userService) {
        this.userService = userService;
    }

    protected String getAuthorizationHeader() {
        return this.authorizationHeader;
    }
}

