/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.auth.handlers;

import org.blufin.core.auth.client.ClientDataContainer;
import org.blufin.core.auth.data.RequestHeaders;
import org.blufin.core.auth.enums.AuthMethod;
import org.blufin.core.auth.exceptions.AuthenticationException;
import org.blufin.core.auth.handlers.AbstractAuthenticationHandler;
import org.blufin.sdk.embedded.service.EmbeddedAccountService;

public class InternalAccountHandler
extends AbstractAuthenticationHandler {
    public static final AuthMethod AUTH_METHOD = AuthMethod.INTERNAL_ACCOUNT;

    public InternalAccountHandler(String authorizationHeader, EmbeddedAccountService accountService) {
        this.setAuthorizationHeader(authorizationHeader);
        this.setAccountService(accountService);
    }

    @Override
    public ClientDataContainer authenticate(RequestHeaders headers) throws AuthenticationException {
        if (headers.getAuthInternal() != null && headers.getAuthInternal().equals(this.getAuthorizationHeader()) && headers.getAuthAccountName() != null) {
            return new ClientDataContainer(AUTH_METHOD, headers.getXRealIP(), this.getAccount(headers.getAuthAccountName(), AUTH_METHOD));
        }
        return null;
    }
}

