/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.auth.handlers;

import org.blufin.core.auth.client.ClientDataContainer;
import org.blufin.core.auth.client.SystemUser;
import org.blufin.core.auth.data.RequestHeaders;
import org.blufin.core.auth.enums.AuthMethod;
import org.blufin.core.auth.exceptions.AuthenticationException;
import org.blufin.core.auth.handlers.AbstractAuthenticationHandler;
import org.blufin.core.utils.UtilsInteger;
import org.blufin.sdk.embedded.dto.common.EmbeddedAccount;
import org.blufin.sdk.embedded.service.EmbeddedAccountService;
import org.blufin.sdk.embedded.service.EmbeddedUserService;

public class InternalAccountUserHandler
extends AbstractAuthenticationHandler {
    public static final AuthMethod AUTH_METHOD = AuthMethod.INTERNAL_ACCOUNT_USER;

    public InternalAccountUserHandler(String authorizationHeader, EmbeddedAccountService accountService, EmbeddedUserService userService) {
        this.setAuthorizationHeader(authorizationHeader);
        this.setAccountService(accountService);
        this.setUserService(userService);
    }

    @Override
    public ClientDataContainer authenticate(RequestHeaders headers) throws AuthenticationException {
        if (headers.getAuthInternal() != null && headers.getAuthInternal().equals(this.getAuthorizationHeader()) && headers.getAuthAccountName() != null && headers.getAuthAccountUser() != null) {
            int userId = UtilsInteger.parseInt(headers.getAuthAccountUser());
            EmbeddedAccount account = this.getAccount(headers.getAuthAccountName(), AUTH_METHOD);
            SystemUser user = userId == 0 ? new SystemUser() : this.getUser(headers.getAuthAccountName(), userId, AUTH_METHOD);
            return new ClientDataContainer(AUTH_METHOD, headers.getXRealIP(), account, user);
        }
        return null;
    }
}

