/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.cloud;

import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClient;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.blufin.base.utils.UtilsLogger;
import org.blufin.core.cloud.queue.MessageClientInterface;
import org.blufin.core.cloud.queue.MessageDeliveryHandler;
import org.blufin.core.cloud.queue.MessageIncoming;
import org.blufin.core.cloud.queue.MessageOutgoing;
import org.blufin.core.cloud.queue.MessageQueueConfig;
import org.blufin.jackson.Jackson;

public class AwsSQSClient
implements MessageClientInterface {
    private static final int MAXIMUM_MESSAGES = 3;
    private static final int MAXIMUM_POLL_TIME = 20;
    private static final int SECONDS_TO_SLEEP_AFTER_RETRIEVAL = 2;
    private final AmazonSQSAsync amazonSQS;
    private final String queueURL;
    private final ReceiveMessageRequest messageRequest;

    public AwsSQSClient(MessageQueueConfig config) throws Exception {
        ReceiveMessageRequest messageRequest = new ReceiveMessageRequest();
        messageRequest.setMaxNumberOfMessages(Integer.valueOf(3));
        messageRequest.setWaitTimeSeconds(Integer.valueOf(20));
        messageRequest.setQueueUrl(config.getHost());
        this.amazonSQS = new AmazonSQSAsyncClient(new ProfileCredentialsProvider().getCredentials());
        this.queueURL = config.getHost();
        this.messageRequest = messageRequest;
    }

    @Override
    public void produce(MessageOutgoing message) throws Exception {
        String messageBody = Jackson.getObjectMapper().writeValueAsString((Object)message);
        this.amazonSQS.sendMessage(new SendMessageRequest(this.queueURL, messageBody));
    }

    @Override
    public void consume(final MessageDeliveryHandler messageDeliveryHandler) {
        Thread messagePoller = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            List messages;
                            if ((messages = AwsSQSClient.this.getMessages()).size() <= 0) {
                                continue;
                            }
                            List<MessageIncoming> successfulMessages = messageDeliveryHandler.handleDelivery(messages);
                            if (successfulMessages.size() > 0) {
                                HashMap<String, String> messagesToDelete = new HashMap<String, String>();
                                for (MessageIncoming successfulMessage : successfulMessages) {
                                    messagesToDelete.put(successfulMessage.getId(), successfulMessage.getReceiptHandle());
                                }
                                AwsSQSClient.this.deleteMessages(messagesToDelete);
                            }
                            if (AwsSQSClient.this.sleepTime() <= 0) continue;
                            Thread.sleep(AwsSQSClient.this.sleepTime());
                        }
                    }
                    catch (InterruptedException e) {
                        UtilsLogger.alertDeveloper((String)"The thread which polls for Amazon SQS messages was interrupted.", (Throwable)e);
                        continue;
                    }
                    catch (Exception e) {
                        UtilsLogger.alertDeveloper((String)"Something went wrong whilst polling for Amazon SQS messages.", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        };
        messagePoller.start();
    }

    private List<MessageIncoming> getMessages() {
        ArrayList<MessageIncoming> sqsMessages = new ArrayList<MessageIncoming>();
        try {
            List messages = this.amazonSQS.receiveMessage(this.messageRequest).getMessages();
            if (messages.size() > 0) {
                for (Message message : messages) {
                    MessageOutgoing sqsMessageContent = (MessageOutgoing)Jackson.getObjectMapper().readValue(message.getBody(), MessageOutgoing.class);
                    MessageIncoming sqsMessage = new MessageIncoming(sqsMessageContent.getType(), sqsMessageContent.getBody(), sqsMessageContent.getIp(), message.getMessageId(), message.getReceiptHandle());
                    sqsMessages.add(sqsMessage);
                }
            }
        }
        catch (Exception e) {
            UtilsLogger.alertDeveloper((String)"Failed to retrieve message(s) from Amazon SQS.", (Throwable)e);
        }
        return sqsMessages;
    }

    private void deleteMessages(Map<String, String> messageIds) {
        if (messageIds.size() == 0) {
            UtilsLogger.alertDeveloper((String)("An empty HashMap (of messages) was passed to " + AwsSQSClient.class.getSimpleName() + ".deleteMessages()."));
            return;
        }
        DeleteMessageBatchResult deleteMessageBatchResult = this.amazonSQS.deleteMessageBatch(this.deleteMessageBatchRequest(messageIds));
        if (deleteMessageBatchResult.getFailed().size() > 1) {
            ArrayList errorEntries = new ArrayList();
            deleteMessageBatchResult.getFailed().forEach(errorEntry -> errorEntries.add(errorEntry.getMessage()));
            UtilsLogger.alertDeveloper((String)"Failed to delete message(s) from Amazon SQS. Received the following error(s):", (String)((Object)errorEntries).toString());
        }
    }

    private DeleteMessageBatchRequest deleteMessageBatchRequest(Map<String, String> messages) {
        ArrayList deleteMessageBatchRequestEntries = new ArrayList();
        if (messages.size() > 0) {
            messages.forEach((id, receiptHandle) -> {
                DeleteMessageBatchRequestEntry deleteMessageBatchRequestEntry = new DeleteMessageBatchRequestEntry();
                deleteMessageBatchRequestEntry.setId(id);
                deleteMessageBatchRequestEntry.setReceiptHandle(receiptHandle);
                deleteMessageBatchRequestEntries.add(deleteMessageBatchRequestEntry);
            });
        }
        DeleteMessageBatchRequest deleteMessageBatchRequest = new DeleteMessageBatchRequest();
        deleteMessageBatchRequest.setEntries(deleteMessageBatchRequestEntries);
        deleteMessageBatchRequest.setQueueUrl(this.queueURL);
        return deleteMessageBatchRequest;
    }

    private int sleepTime() {
        return 2000;
    }
}

