/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.cloud.queue;

import java.util.concurrent.atomic.AtomicBoolean;
import org.blufin.base.utils.UtilsEnvironment;
import org.blufin.base.utils.UtilsLogger;
import org.blufin.core.cloud.AwsSQSClient;
import org.blufin.core.cloud.queue.MessageClientInterface;
import org.blufin.core.cloud.queue.MessageDeliveryHandler;
import org.blufin.core.cloud.queue.MessageOutgoing;
import org.blufin.core.cloud.queue.MessageQueueConfig;
import org.blufin.core.cloud.queue.RabbitMQClient;

public class MessageClient
implements MessageClientInterface {
    private static volatile MessageClient instance;
    private MessageClientInterface messageClient;
    private AtomicBoolean consumingStarted = new AtomicBoolean(false);

    private MessageClient() {
        try {
            this.messageClient = UtilsEnvironment.isLocal() || UtilsEnvironment.isDevelopment() ? new RabbitMQClient(MessageQueueConfig.getInstance()) : new AwsSQSClient(MessageQueueConfig.getInstance());
        }
        catch (Exception e) {
            UtilsLogger.error((String)"MessageClient failed to load.", (Throwable)e);
        }
    }

    public static final MessageClient getInstance() {
        if (instance == null) {
            instance = new MessageClient();
        }
        return instance;
    }

    @Override
    public void consume(MessageDeliveryHandler messageDeliveryHandler) {
        if (this.consumingStarted.get()) {
            throw new RuntimeException("MessageQueueClient.consume() was called twice.");
        }
        this.consumingStarted.set(true);
        this.messageClient.consume(messageDeliveryHandler);
    }

    @Override
    public void produce(MessageOutgoing message) throws Exception {
        MessageClient.getInstance().messageClient.produce(message);
    }
}

