/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.cloud.queue;

import com.google.common.base.Charsets;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.util.ArrayList;
import org.blufin.base.utils.UtilsLogger;
import org.blufin.core.cloud.queue.MessageClientInterface;
import org.blufin.core.cloud.queue.MessageDeliveryHandler;
import org.blufin.core.cloud.queue.MessageIncoming;
import org.blufin.core.cloud.queue.MessageOutgoing;
import org.blufin.core.cloud.queue.MessageQueueConfig;
import org.blufin.jackson.Jackson;

public class RabbitMQClient
implements MessageClientInterface {
    private final Channel channel;
    private final MessageQueueConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RabbitMQClient(MessageQueueConfig config) {
        Channel channel = null;
        try {
            ConnectionFactory factory = new ConnectionFactory();
            factory.setHost(config.getHost());
            channel = factory.newConnection().createChannel();
            channel.queueDeclare(config.getName(), false, false, false, null);
        }
        catch (Exception e) {
            UtilsLogger.error((String)"Failed to initialize a RabbitMQ connection.", (Throwable)e);
        }
        finally {
            this.config = config;
            this.channel = channel;
        }
    }

    @Override
    public void produce(MessageOutgoing message) throws Exception {
        this.channel.basicPublish("", this.config.getName(), null, Jackson.getObjectMapper().writeValueAsString((Object)message).getBytes(Charsets.UTF_8));
    }

    @Override
    public void consume(final MessageDeliveryHandler messageDeliveryHandler) {
        try {
            this.channel.basicConsume(this.config.getName(), false, (Consumer)new DefaultConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
                    String messageBody = "";
                    try {
                        ArrayList<MessageIncoming> messages = new ArrayList<MessageIncoming>();
                        messageBody = new String(body, "UTF-8");
                        MessageOutgoing messageIncomingContent = (MessageOutgoing)Jackson.getObjectMapper().readValue(messageBody, MessageOutgoing.class);
                        MessageIncoming messageIncoming = new MessageIncoming(messageIncomingContent.getType(), messageIncomingContent.getBody(), messageIncomingContent.getIp(), properties.getMessageId(), String.valueOf(envelope.getDeliveryTag()));
                        messages.add(messageIncoming);
                        messageDeliveryHandler.handleDelivery(messages);
                    }
                    catch (Exception e) {
                        UtilsLogger.alertDeveloper((String)"Failed to convert a message from RabbitMQ to <MessageIncoming> type.", (String)messageBody, (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            UtilsLogger.error((String)"Failed to consume message(s) from RabbitMQ.", (Throwable)e);
        }
    }
}

