/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.cloud.storage;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;
import org.blufin.base.utils.UtilsLogger;

public class AwsS3Client {
    public static final String TMP_FILE_DIRECTORY = "/tmp";
    public static final String TMP_FILE_EXTENSION = "txt";
    private final AmazonS3Client amazonS3Client;
    private final String bucket;

    public AwsS3Client(AmazonS3Client amazonS3Client, String bucket) {
        this.bucket = bucket;
        this.amazonS3Client = amazonS3Client;
    }

    public String uploadStringToS3(String data) {
        return this.uploadFileToS3(this.getFileFromString(data));
    }

    public String uploadFileToS3(File file) {
        String uuid = this.getUUID();
        try {
            this.amazonS3Client.putObject(new PutObjectRequest(this.bucket, uuid, file));
            if (!file.delete()) {
                UtilsLogger.error((String)("Upload to Amazon S3 succeeded but file '" + file.getName() + "' failed to delete."));
            }
            return uuid;
        }
        catch (Exception e) {
            UtilsLogger.error((String)("Uploading file '" + file.getName() + "' to Amazon S3 failed."), (Throwable)e);
            return null;
        }
    }

    private String getUUID() {
        return String.valueOf(UUID.randomUUID());
    }

    private File getFileFromString(String data) {
        String tmpFileName = "/tmp/" + this.getUUID() + "" + TMP_FILE_EXTENSION;
        try {
            Files.write((CharSequence)data, (File)new File(tmpFileName), (Charset)Charset.forName("UTF-8"));
            return new File(tmpFileName);
        }
        catch (IOException e) {
            UtilsLogger.error((String)("File upload failed for: " + tmpFileName), (Throwable)e);
            return null;
        }
    }
}

