/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import java.io.IOException;
import java.text.MessageFormat;
import org.blufin.base.utils.UtilsLogger;
import org.blufin.core.http.HttpClientResponse;

public class HttpClient {
    public static HttpClientResponse get(String url) {
        try {
            HttpResponse jsonResponse = Unirest.get((String)url).asString();
            return new HttpClientResponse(jsonResponse.getStatus(), jsonResponse.getStatusText(), (String)jsonResponse.getBody());
        }
        catch (Exception e) {
            UtilsLogger.error((String)MessageFormat.format("HTTP GET to ''{0}'' failed.", url), (Throwable)e);
            return null;
        }
    }

    public static HttpClientResponse postJsonString(String url, String jsonString) {
        try {
            HttpResponse jsonResponse = Unirest.post((String)url).header("accept", "application/json").body(jsonString).asString();
            return new HttpClientResponse(jsonResponse.getStatus(), jsonResponse.getStatusText(), (String)jsonResponse.getBody());
        }
        catch (Exception e) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                Object json = mapper.readValue(jsonString, Object.class);
                UtilsLogger.error((String)MessageFormat.format("HTTP POST to ''{0}'' failed.", url), (String)mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json), (Throwable)e);
            }
            catch (IOException e1) {
                UtilsLogger.error((String)("HTTP POST to '" + url + "' failed -- as did the JSON prettifying."), (String)jsonString, (Throwable)e);
            }
            return null;
        }
    }
}

