/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.security;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.blufin.base.helper.Pair;
import org.blufin.base.interfaces.Initializable;

public class Encryptor
extends Initializable<Pair<String, String>> {
    public static final Encryptor instance = new Encryptor();
    private IvParameterSpec ivParameterSpec;
    private SecretKeySpec secretKeySpec;

    private Encryptor() {
    }

    @Deprecated
    public static Encryptor createDuplicateSingleton(Pair<String, String> configuration) {
        Encryptor encryptor = new Encryptor();
        encryptor.initializeClass(configuration);
        return encryptor;
    }

    public static void initialize(Pair<String, String> configuration) {
        instance.initializeClass(configuration);
        Encryptor.decryptWithoutException("USED-FOR-INITIALIZATION");
    }

    public static void shutdown() {
        instance.shutdownClass();
    }

    public static String encrypt(String stringToEncrypt) throws Exception {
        return instance.encryptDynamicallyBound(stringToEncrypt);
    }

    public static String decrypt(String stringToDecrypt) throws Exception {
        return instance.decryptDynamicallyBound(stringToDecrypt);
    }

    public String encryptDynamicallyBound(String stringToEncrypt) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(1, (Key)this.getSecretKeySpec(), this.getIvParameterSpec());
        byte[] encrypted = cipher.doFinal(stringToEncrypt.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBase64String((byte[])encrypted);
    }

    public String decryptDynamicallyBound(String encryptedString) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(2, (Key)this.getSecretKeySpec(), this.getIvParameterSpec());
        byte[] original = cipher.doFinal(Base64.decodeBase64((String)encryptedString));
        return new String(original, StandardCharsets.UTF_8);
    }

    public static String encryptWithoutException(String stringToEncrypt) {
        try {
            return instance.encryptDynamicallyBound(stringToEncrypt);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String decryptWithoutException(String encryptedString) {
        try {
            return instance.decryptDynamicallyBound(encryptedString);
        }
        catch (Exception e) {
            return "";
        }
    }

    private IvParameterSpec getIvParameterSpec() {
        if (this.ivParameterSpec == null) {
            this.ivParameterSpec = new IvParameterSpec(((String)((Pair)this.getInitializationData()).getValue()).getBytes(StandardCharsets.UTF_8));
        }
        return this.ivParameterSpec;
    }

    private SecretKeySpec getSecretKeySpec() {
        if (this.secretKeySpec == null) {
            this.secretKeySpec = new SecretKeySpec(((String)((Pair)this.getInitializationData()).getKey()).getBytes(StandardCharsets.UTF_8), "AES");
        }
        return this.secretKeySpec;
    }
}

