/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.server.aws;

import com.amazonaws.util.EC2MetadataUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.blufin.base.enums.Environment;
import org.blufin.base.interfaces.Initializable;
import org.blufin.base.utils.UtilsLogger;
import org.blufin.core.server.aws.AWSInstanceData;

public class AWSInstanceDataResolver
extends Initializable<Environment> {
    private static AWSInstanceDataResolver instance = new AWSInstanceDataResolver();
    private AWSInstanceData awsInstanceData = new AWSInstanceData();
    private Environment environment;
    private boolean startupLoggingComplete = false;

    public static void initialize(Environment environment) {
        instance.initializeClass(environment);
        instance.resolve();
    }

    public static AWSInstanceData getInstanceData() {
        return AWSInstanceDataResolver.instance.awsInstanceData;
    }

    public static void resolve() {
        if (instance.getEnvironment().equals((Object)Environment.PRODUCTION) || instance.getEnvironment().equals((Object)Environment.STAGING)) {
            if (!AWSInstanceDataResolver.instance.startupLoggingComplete) {
                throw new RuntimeException();
            }
            HashMap<String, String> metaData = new HashMap<String, String>();
            List<String> metaDataKeys = Arrays.asList("ami-id", "ami-launch-index", "ami-manifest-path", "hostname", "instance-action", "instance-id", "instance-type", "local-hostname", "local-ipv4", "mac", "profile", "public-hostname", "public-ipv4", "reservation-id", "security-groups");
            for (String metaDataKey : metaDataKeys) {
                metaData.put(metaDataKey, EC2MetadataUtils.getData((String)("/latest/meta-data/" + metaDataKey)));
                if (AWSInstanceDataResolver.instance.startupLoggingComplete) continue;
                UtilsLogger.logPurple((String)(metaDataKey + ": " + "\u001b[33m" + (String)metaData.get(metaDataKey)));
            }
            AWSInstanceDataResolver.instance.awsInstanceData = new AWSInstanceData((String)metaData.get("ami-id"), (String)metaData.get("ami-launch-index"), (String)metaData.get("ami-manifest-path"), (String)metaData.get("hostname"), (String)metaData.get("instance-action"), (String)metaData.get("instance-id"), (String)metaData.get("instance-type"), (String)metaData.get("local-hostname"), (String)metaData.get("local-ipv4"), (String)metaData.get("mac"), (String)metaData.get("profile"), (String)metaData.get("public-hostname"), (String)metaData.get("public-ipv4"), (String)metaData.get("reservation-id"), (String)metaData.get("security-groups"));
        }
        AWSInstanceDataResolver.instance.startupLoggingComplete = true;
    }

    private Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = (Environment)this.getInitializationData();
            if (!(this.environment.equals((Object)Environment.DEVELOPMENT) || this.environment.equals((Object)Environment.STAGING) || this.environment.equals((Object)Environment.PRODUCTION))) {
                throw new RuntimeException(MessageFormat.format("Invalid environment ''{0}''. Must be either: {1}, {2} or {3}", this.environment, Environment.DEVELOPMENT, Environment.STAGING, Environment.PRODUCTION));
            }
        }
        return this.environment;
    }
}

