/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.server.db;

import java.sql.Connection;
import java.text.MessageFormat;
import org.blufin.base.enums.SchemaType;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.base.exceptions.BlufinServerException;
import org.blufin.core.auth.client.ClientDataFactory;
import org.blufin.core.server.db.AccountAwareDataSource;
import org.blufin.core.server.db.CommonDataSource;
import org.blufin.core.server.db.ConfigDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectionFactory {
    @Autowired
    AccountAwareDataSource accountAwareDataSource;
    @Autowired
    CommonDataSource commonDataSource;
    @Autowired
    ConfigDataSource configDataSource;

    public Connection getConnection(SchemaType schemaType) throws BlufinServerException {
        switch (schemaType) {
            case APP: {
                return this.accountAwareDataSource.getConnection(ClientDataFactory.getClientData().getAccount().getAccountName());
            }
            case COMMON: {
                return this.commonDataSource.getConnection();
            }
            case CONFIG: {
                return this.configDataSource.getConnection();
            }
        }
        throw new BlufinAlertDeveloperException(MessageFormat.format("Unsupported schema: {0}", schemaType.name()));
    }
}

