/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.server.db.base;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.blufin.core.server.db.data.DataSourceConfiguration;
import org.blufin.core.utils.UtilsThread;

public abstract class AbstractDataSource {
    private static final int REFRESH_TIMEOUT = 5;
    protected volatile boolean refreshInProgress = false;

    protected HikariDataSource build(DataSourceConfiguration dataSourceConfiguration) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : dataSourceConfiguration.getJdbcProperties().entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName("com.mysql.cj.jdbc.Driver");
        hikariConfig.setJdbcUrl(dataSourceConfiguration.getJdbcUrl());
        hikariConfig.setUsername(dataSourceConfiguration.getUser());
        hikariConfig.setPassword(dataSourceConfiguration.getPassword());
        hikariConfig.setPoolName(dataSourceConfiguration.getPoolName());
        hikariConfig.setMaximumPoolSize(dataSourceConfiguration.getPoolMaxSize());
        hikariConfig.setDataSourceProperties(properties);
        hikariConfig.setRegisterMbeans(true);
        hikariConfig.setLeakDetectionThreshold(5000L);
        String schema = dataSourceConfiguration.getSchema();
        if (schema != null && !schema.trim().equals("")) {
            hikariConfig.setCatalog(schema);
        }
        return new HikariDataSource(hikariConfig);
    }

    protected void waitWhileRefreshing() throws TimeoutException {
        int seconds = 0;
        while (this.refreshInProgress) {
            if (++seconds > 5) {
                throw new TimeoutException(MessageFormat.format("Maximum timeout of {0} seconds exceeded.", 5));
            }
            UtilsThread.sleep(1000);
        }
    }
}

