/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.server.db.base;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeoutException;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.core.server.db.base.AbstractDataSource;
import org.blufin.core.server.db.data.DataSourceConfiguration;

public class AbstractDataSourceSingle
extends AbstractDataSource {
    private volatile HikariDataSource dataSource = null;
    private volatile String schema = null;

    protected void refreshDataSources(DataSourceConfiguration configuration) {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
        this.schema = configuration.getSchema();
        if (this.schema == null || this.schema.trim().equals("")) {
            throw new BlufinAlertDeveloperException("When refreshing a SingleDataSource, schema cannot be null.");
        }
        this.dataSource = this.build(configuration);
    }

    protected Connection getDataConnection() throws SQLException, TimeoutException {
        if (this.dataSource == null) {
            throw new BlufinAlertDeveloperException("An implementation of a SingleDataSource was not properly initialized. Must call refresh() first.");
        }
        this.waitWhileRefreshing();
        Connection connection = this.dataSource.getConnection();
        connection.setCatalog(this.schema);
        connection.setAutoCommit(false);
        return connection;
    }
}

