/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.server.deserialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.TimeZone;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.base.exceptions.BlufinClientException;
import org.blufin.base.helper.Pair;
import org.blufin.base.utils.UtilsDate;
import org.blufin.base.utils.UtilsLogger;
import org.blufin.base.utils.UtilsString;
import org.blufin.core.auth.client.ClientData;
import org.blufin.jackson.Jackson;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.base.MetaDataException;
import org.blufin.sdk.normalization.DataNormalizationException;
import org.blufin.sdk.normalization.DataNormalizer;
import org.blufin.sdk.normalization.TerminologyNormalizer;
import org.blufin.sdk.response.AckError;
import org.blufin.sdk.response.AckResolver;
import org.blufin.sdk.response.AckWarning;

public class JsonMappingValidator {
    public static final int LIST_LENGTH = "_list".length();
    public static final String ERROR_PAYLOAD_EMPTY = "Received empty payload. Expected \u2192 {0}";
    public static final String ERROR_PAYLOAD_EMPTY_LIST = "Received empty List. Expected \u2192 List of Objects ({0})";
    public static final String ERROR_PAYLOAD_INVALID_TYPE = "Invalid payload. Expected: {0} . Got \u2192 {1}";
    public static final String ERROR_PAYLOAD_INVALID_TYPE_WITH_VALUE = "Invalid payload. Expected: {0} . Got \u2192 {1} ({2})";
    public static final String ERROR_TRANSIENT_NULL_SUFFIX = " (not even as NULL)";

    public static void validate(JsonNode incomingNode, JsonNode outgoingNode, AckResolver ackResolver, AbstractMetaData metaData, TerminologyNormalizer.Type expectedNode) {
        JsonMappingValidator.validate(incomingNode, outgoingNode, ackResolver, metaData, expectedNode, "");
    }

    private static void validate(JsonNode incomingNode, JsonNode outgoingNode, AckResolver ackResolver, AbstractMetaData metaData, TerminologyNormalizer.Type expectedNode, String tree) {
        if (incomingNode == null) {
            throw new BlufinClientException(AckError.JSON_ERROR.toString(new String[]{MessageFormat.format(ERROR_PAYLOAD_EMPTY, expectedNode)}));
        }
        JsonMappingValidator.validateNodeType(incomingNode, expectedNode);
        if (incomingNode.isArray()) {
            if (incomingNode.size() == 0 && !metaData.isNestedObjectList()) {
                throw new BlufinClientException(AckError.JSON_ERROR.toString(new String[]{MessageFormat.format(ERROR_PAYLOAD_EMPTY_LIST, UtilsString.underscoreToUpperCamel((String)metaData.getTable()))}));
            }
            for (int i = 0; i < incomingNode.size(); ++i) {
                ObjectNode nestedNode = Jackson.getObjectMapper().createObjectNode();
                JsonMappingValidator.validate(incomingNode.get(i), (JsonNode)nestedNode, ackResolver, metaData, tree);
                ((ArrayNode)outgoingNode).add((JsonNode)nestedNode);
            }
        } else {
            JsonMappingValidator.validate(incomingNode, outgoingNode, ackResolver, metaData, tree);
        }
    }

    private static void validate(JsonNode incomingNode, JsonNode outgoingNode, AckResolver ackResolver, AbstractMetaData metaData, String tree) throws BlufinClientException {
        JsonMappingValidator.validateNodeType(incomingNode, TerminologyNormalizer.Type.OBJECT);
        Iterator fields = incomingNode.fields();
        ArrayList<String> unrecognizedProperties = new ArrayList<String>();
        List requiredFields = metaData.getRequiredFieldsIncludingContainers();
        block20: while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String fieldName = (String)entry.getKey();
            String fieldNameUnderScore = UtilsString.camelToUnderscore((String)((String)entry.getKey()));
            String fieldNameWithTree = tree.equals("") ? fieldName : tree + "." + fieldName;
            JsonNode value = (JsonNode)entry.getValue();
            try {
                if (!metaData.containsField(fieldNameUnderScore)) {
                    throw new MetaDataException();
                }
                if (requiredFields.contains(fieldNameUnderScore)) {
                    requiredFields.remove(fieldNameUnderScore);
                }
                if (metaData.isTransient(fieldNameUnderScore)) {
                    ackResolver.addWarning(AckWarning.TRANSIENT_PROPERTY_IGNORED, new String[]{fieldNameWithTree, ERROR_TRANSIENT_NULL_SUFFIX});
                    continue;
                }
                if (value.isNull()) {
                    if (!metaData.getType(fieldNameUnderScore).equals((Object)DataType.OBJECT_LIST)) continue;
                    ackResolver.addError(AckError.JSON_NULL_NOT_ALLOWED_FOR_LIST, new String[]{fieldNameWithTree});
                    continue;
                }
                if (AbstractMetaData.CONTAINER_TYPES.contains(metaData.getType(fieldNameUnderScore)) && !value.isContainerNode() || !AbstractMetaData.CONTAINER_TYPES.contains(metaData.getType(fieldNameUnderScore)) && value.isContainerNode()) {
                    ackResolver.addError(AckError.JSON_TYPE_MISMATCH, new String[]{fieldNameWithTree, metaData.getType(fieldNameUnderScore).toString(), value.getNodeType().toString()});
                    continue;
                }
                switch (metaData.getType(fieldNameUnderScore)) {
                    case BOOLEAN: {
                        ((ObjectNode)outgoingNode).put(fieldName, DataNormalizer.normalizeBoolean((String)value.asText(), (String)fieldNameWithTree, (AckResolver)ackResolver));
                        if (value.isBoolean()) continue block20;
                        ackResolver.addWarning(AckWarning.JSON_TYPE_MISMATCH, new String[]{fieldNameWithTree, JsonNodeType.BOOLEAN.toString(), value.getNodeType().toString(), value.asText()});
                        break;
                    }
                    case DATE: {
                        ((ObjectNode)outgoingNode).put(fieldName, UtilsDate.convertLocalDateToString((LocalDate)DataNormalizer.normalizeDate((String)value.asText(), (String)fieldNameWithTree, (AckResolver)ackResolver)));
                        break;
                    }
                    case DATETIME: {
                        ((ObjectNode)outgoingNode).put(fieldName, String.valueOf(DataNormalizer.normalizeDateTime((String)value.asText(), (String)fieldNameWithTree, (AckResolver)ackResolver, (TimeZone)ClientData.getTimeZone())));
                        break;
                    }
                    case DATETIME_INSERT: {
                        throw new BlufinAlertDeveloperException(MessageFormat.format("{0} should always be transient and this statement should never be reached.", DataType.DATETIME_INSERT.toString()));
                    }
                    case DATETIME_UPDATE: {
                        throw new BlufinAlertDeveloperException(MessageFormat.format("{0} should always be transient and this statement should never be reached.", DataType.DATETIME_UPDATE.toString()));
                    }
                    case DECIMAL: {
                        String valueAsString = value.isBigDecimal() ? value.decimalValue().toPlainString() : value.asText();
                        ((ObjectNode)outgoingNode).put(fieldName, DataNormalizer.normalizeDecimal((String)valueAsString, (String)fieldNameWithTree, (AckResolver)ackResolver, (Pair)metaData.getDecimalDistribution(fieldNameUnderScore)).toPlainString());
                        if (value.isNumber()) continue block20;
                        ackResolver.addWarning(AckWarning.JSON_TYPE_MISMATCH, new String[]{fieldNameWithTree, JsonNodeType.NUMBER.toString(), value.getNodeType().toString(), value.asText()});
                        break;
                    }
                    case ENUM: 
                    case ENUM_CUSTOM: 
                    case ENUM_SYSTEM: {
                        ((ObjectNode)outgoingNode).put(fieldName, DataNormalizer.normalizeStringEnum((String)value.asText(), (String)fieldNameWithTree, (AckResolver)ackResolver, (List)metaData.getEnumValues(fieldNameUnderScore)));
                        break;
                    }
                    case INT: 
                    case INT_AUTO: {
                        ((ObjectNode)outgoingNode).put(fieldName, DataNormalizer.normalizeInt((String)value.asText(), (String)fieldNameWithTree, (AckResolver)ackResolver));
                        if (value.isNumber()) continue block20;
                        ackResolver.addWarning(AckWarning.JSON_TYPE_MISMATCH, new String[]{fieldNameWithTree, JsonNodeType.NUMBER.toString(), value.getNodeType().toString(), value.asText()});
                        break;
                    }
                    case INT_TINY: {
                        ((ObjectNode)outgoingNode).put(fieldName, (short)DataNormalizer.normalizeIntTiny((String)value.asText(), (String)fieldNameWithTree, (AckResolver)ackResolver));
                        if (value.isNumber()) continue block20;
                        ackResolver.addWarning(AckWarning.JSON_TYPE_MISMATCH, new String[]{fieldNameWithTree, JsonNodeType.NUMBER.toString(), value.getNodeType().toString(), value.asText()});
                        break;
                    }
                    case INT_SMALL: {
                        ((ObjectNode)outgoingNode).put(fieldName, DataNormalizer.normalizeIntSmall((String)value.asText(), (String)fieldNameWithTree, (AckResolver)ackResolver));
                        if (value.isNumber()) continue block20;
                        ackResolver.addWarning(AckWarning.JSON_TYPE_MISMATCH, new String[]{fieldNameWithTree, JsonNodeType.NUMBER.toString(), value.getNodeType().toString(), value.asText()});
                        break;
                    }
                    case INT_BIG: {
                        ((ObjectNode)outgoingNode).put(fieldName, DataNormalizer.normalizeIntBig((String)value.asText(), (String)fieldNameWithTree, (AckResolver)ackResolver));
                        if (value.isNumber()) continue block20;
                        ackResolver.addWarning(AckWarning.JSON_TYPE_MISMATCH, new String[]{fieldNameWithTree, JsonNodeType.NUMBER.toString(), value.getNodeType().toString(), value.asText()});
                        break;
                    }
                    case TEXT: 
                    case TEXT_LONG: 
                    case VARCHAR: {
                        ((ObjectNode)outgoingNode).put(fieldName, value.asText());
                        if (value.isTextual()) continue block20;
                        ackResolver.addWarning(AckWarning.JSON_TYPE_MISMATCH, new String[]{fieldNameWithTree, JsonNodeType.STRING.toString(), value.getNodeType().toString(), "\"" + value.asText() + "\""});
                        break;
                    }
                    case OBJECT: {
                        if (!value.isObject()) {
                            ackResolver.addError(AckError.JSON_TYPE_MISMATCH, new String[]{fieldNameWithTree, DataType.OBJECT.toString(), value.getNodeType().toString()});
                            continue block20;
                        }
                        ObjectNode nestedOutgoingObjectNode = Jackson.getObjectMapper().createObjectNode();
                        JsonMappingValidator.validate(value, (JsonNode)nestedOutgoingObjectNode, ackResolver, metaData.getNestedMetaData(fieldNameUnderScore), TerminologyNormalizer.Type.OBJECT, fieldNameWithTree);
                        ((ObjectNode)outgoingNode).set(fieldName, (JsonNode)nestedOutgoingObjectNode);
                        break;
                    }
                    case OBJECT_LIST: {
                        if (!value.isArray()) {
                            ackResolver.addError(AckError.JSON_TYPE_MISMATCH, new String[]{fieldNameWithTree, DataType.OBJECT_LIST.toString(), value.getNodeType().toString()});
                            continue block20;
                        }
                        ArrayNode nestedArrayNode = Jackson.getObjectMapper().createArrayNode();
                        for (int i = 0; i < value.size(); ++i) {
                            ObjectNode nestedNode = Jackson.getObjectMapper().createObjectNode();
                            JsonMappingValidator.validate(value.get(i), (JsonNode)nestedNode, ackResolver, metaData.getNestedMetaData(fieldNameUnderScore.substring(0, fieldNameUnderScore.length() - LIST_LENGTH)), fieldNameWithTree);
                            nestedArrayNode.add((JsonNode)nestedNode);
                        }
                        ((ObjectNode)outgoingNode).set(fieldName, (JsonNode)nestedArrayNode);
                        break;
                    }
                    case OBJECT_LINK: {
                        continue block20;
                    }
                    default: {
                        throw new BlufinAlertDeveloperException(MessageFormat.format("Unhandled DataType: {0}", metaData.getType(fieldNameUnderScore)));
                    }
                }
            }
            catch (MetaDataException e) {
                unrecognizedProperties.add(fieldNameWithTree);
            }
            catch (DataNormalizationException dataNormalizationException) {}
        }
        if (unrecognizedProperties.size() > 0) {
            ackResolver.addError(AckError.JSON_UNRECOGNIZED_PROPERTIES, new String[]{String.join((CharSequence)", ", unrecognizedProperties)});
        }
        if (requiredFields.size() > 0) {
            ArrayList requiredFieldsCamelCased = new ArrayList();
            requiredFields.forEach(requiredField -> requiredFieldsCamelCased.add(tree.equals("") ? UtilsString.underscoreToLowerCamel((String)requiredField) : tree + "." + UtilsString.underscoreToLowerCamel((String)requiredField)));
            ackResolver.addError(AckError.JSON_MISSING_PROPERTIES, new String[]{String.join((CharSequence)", ", requiredFieldsCamelCased)});
        }
    }

    private static void validateNodeType(JsonNode rootNode, TerminologyNormalizer.Type expectedNode) throws BlufinClientException {
        switch (rootNode.getNodeType()) {
            case ARRAY: {
                if (expectedNode == TerminologyNormalizer.Type.LIST) break;
                throw new BlufinClientException(AckError.JSON_ERROR.toString(new String[]{MessageFormat.format(ERROR_PAYLOAD_INVALID_TYPE, expectedNode, TerminologyNormalizer.type((String)rootNode.getNodeType().toString()))}));
            }
            case OBJECT: {
                if (expectedNode == TerminologyNormalizer.Type.OBJECT) break;
                throw new BlufinClientException(AckError.JSON_ERROR.toString(new String[]{MessageFormat.format(ERROR_PAYLOAD_INVALID_TYPE, expectedNode, TerminologyNormalizer.type((String)rootNode.getNodeType().toString()))}));
            }
            case NUMBER: {
                throw new BlufinClientException(AckError.JSON_ERROR.toString(new String[]{MessageFormat.format(ERROR_PAYLOAD_INVALID_TYPE_WITH_VALUE, expectedNode, TerminologyNormalizer.type((String)rootNode.getNodeType().toString()), rootNode.toString().trim().replaceAll("^\\s*\"", "").replaceAll("\"\\s*$", ""))}));
            }
            case STRING: {
                throw new BlufinClientException(AckError.JSON_ERROR.toString(new String[]{MessageFormat.format(ERROR_PAYLOAD_INVALID_TYPE_WITH_VALUE, expectedNode, TerminologyNormalizer.type((String)rootNode.getNodeType().toString()), "'" + rootNode.toString().trim().replaceAll("^\\s*\"", "").replaceAll("\"\\s*$", "") + "'")}));
            }
            case BINARY: 
            case BOOLEAN: 
            case MISSING: 
            case NULL: 
            case POJO: {
                throw new BlufinClientException(AckError.JSON_ERROR.toString(new String[]{MessageFormat.format(ERROR_PAYLOAD_INVALID_TYPE, expectedNode, TerminologyNormalizer.type((String)rootNode.getNodeType().toString()))}));
            }
            default: {
                UtilsLogger.alertDeveloper((String)MessageFormat.format("Un-handled JSON NodeType: {0}", rootNode.getNodeType()));
                throw new BlufinClientException(AckError.JSON_ERROR.toString(new String[]{MessageFormat.format(ERROR_PAYLOAD_INVALID_TYPE, expectedNode, TerminologyNormalizer.type((String)rootNode.getNodeType().toString()))}));
            }
        }
    }
}

