/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.server.helper;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.blufin.base.enums.SchemaType;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.base.exceptions.BlufinServerException;
import org.blufin.base.helper.Pair;
import org.blufin.core.auth.core.AuthInitializationLevel;
import org.blufin.core.server.db.AccountAwareDataSource;
import org.blufin.sdk.embedded.base.EmbeddedSDK;
import org.blufin.sdk.embedded.dto.common.EmbeddedAccount;
import org.blufin.sdk.embedded.dto.config.EmbeddedDb;
import org.blufin.sdk.embedded.dto.config.EmbeddedProject;
import org.blufin.sdk.embedded.refiner.EmbeddedDbRefiner;
import org.blufin.sdk.embedded.refiner.EmbeddedProjectRefiner;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class AccountAwareDataSourceRefresher {
    @Autowired
    EmbeddedSDK embeddedSDK;
    @Autowired
    AccountAwareDataSource accountAwareDataSource;
    private String projectName;
    private AuthInitializationLevel authInitializationLevel;

    public Pair<List<? extends EmbeddedDb>, List<? extends EmbeddedAccount>> refresh() throws BlufinServerException {
        if (Arrays.asList(AuthInitializationLevel.INTERNAL_ACCOUNT_USER, AuthInitializationLevel.OAUTH_ACCOUNT_USER).contains((Object)this.authInitializationLevel)) {
            List databaseList = ((PaginatedGetRequest)((EmbeddedDbRefiner)((PaginatedGetRequest)((EmbeddedDbRefiner)this.embeddedSDK.getEmbeddedDbService().get().where()).projectId().is(this.getProjectId())).where()).schemaType().is((Enum)SchemaType.APP)).execute().getBody();
            List accountList = this.embeddedSDK.getEmbeddedAccountService().get().execute().getBody();
            this.accountAwareDataSource.refresh(databaseList, accountList);
            return Pair.of((Object)databaseList, (Object)accountList);
        }
        throw new BlufinAlertDeveloperException(MessageFormat.format("This code should never be reached. Authentication Level does not support this operation: {0}", this.authInitializationLevel.toString()));
    }

    private int getProjectId() {
        List projectList = ((PaginatedGetRequest)((EmbeddedProjectRefiner)this.embeddedSDK.getEmbeddedProjectService().get().where()).projectName().is(this.projectName)).execute().getBody();
        if (projectList.size() != 1) {
            throw new BlufinAlertDeveloperException(MessageFormat.format("{0} expected exactly one project named ''{1}'' to exist in the database, instead got \u2192 {2}", AccountAwareDataSourceRefresher.class.getSimpleName(), this.projectName, projectList.size()));
        }
        return ((EmbeddedProject)projectList.get(0)).getId();
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setAuthInitializationLevel(AuthInitializationLevel authInitializationLevel) {
        this.authInitializationLevel = authInitializationLevel;
    }
}

