/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.server.helper;

import java.text.MessageFormat;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.base.utils.UtilsNumber;
import org.blufin.base.utils.UtilsString;
import org.blufin.sdk.enums.HttpMethod;

public final class EndPointHelper {
    public static final String LIST_SUFFIX = "/list";

    public static final String normalizeEndPoint(String endPoint, HttpMethod method) {
        endPoint = UtilsString.rtrim((String)UtilsString.ltrim((String)endPoint, (String)"/"), (String)"/");
        switch (method) {
            case POST: 
            case PUT: {
                endPoint = EndPointHelper.normalize(endPoint);
                break;
            }
            case GET: 
            case PATCH: 
            case DELETE: {
                break;
            }
            default: {
                throw new BlufinAlertDeveloperException(MessageFormat.format("Unhandled {0}: {1}", HttpMethod.class.getSimpleName(), method.toString()));
            }
        }
        return endPoint;
    }

    private static String normalize(String endPoint) {
        endPoint = UtilsString.rtrim((String)endPoint, (String)LIST_SUFFIX);
        StringBuilder sb = new StringBuilder();
        String[] endPointParts = endPoint.split("/");
        for (int i = 0; i < endPointParts.length; ++i) {
            if (i == endPointParts.length - 2 && UtilsNumber.isInteger((String)endPointParts[i])) continue;
            sb.append(endPointParts[i]);
            if (i >= endPointParts.length - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }
}

