/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.server.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.blufin.base.enums.Environment;
import org.blufin.base.exceptions.BlufinClientException;
import org.blufin.base.utils.UtilsEnvironment;
import org.blufin.core.server.deserialization.JsonMappingValidator;
import org.blufin.core.server.helper.EndPointHelper;
import org.blufin.core.server.rest.ModifiedServletInputStream;
import org.blufin.core.server.startup.ApiApplication;
import org.blufin.jackson.Jackson;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.enums.HttpMethod;
import org.blufin.sdk.exceptions.ResourceNotFoundException;
import org.blufin.sdk.normalization.TerminologyNormalizer;
import org.blufin.sdk.response.AckError;
import org.blufin.sdk.response.AckResolver;
import org.blufin.sdk.response.AckResolverThreadLocal;

public class ModifiedRequest
extends HttpServletRequestWrapper {
    public static final String ERROR_INVALID_JSON = "Invalid JSON. Please check your syntax and try again.";
    private static final ObjectMapper mapper = Jackson.getObjectMapper();
    private AbstractMetaData metaData;
    private ServletInputStream modifiedInputStream;

    public ModifiedRequest(HttpServletRequest servletRequest) throws IOException {
        super(servletRequest);
        this.modifiedInputStream = servletRequest.getInputStream();
        try {
            String endPoint = EndPointHelper.normalizeEndPoint(servletRequest.getRequestURI(), HttpMethod.valueOf((String)servletRequest.getMethod().toUpperCase()));
            this.metaData = ApiApplication.getResourceData().getMetaData(endPoint);
        }
        catch (ResourceNotFoundException e) {
            return;
        }
    }

    public void validate(TerminologyNormalizer.Type expectedType) {
        if (this.metaData != null) {
            try {
                AckResolver ackResolver = new AckResolver();
                JsonNode incomingNode = mapper.readTree((InputStream)this.modifiedInputStream);
                ObjectNode outgoingNode = expectedType.equals((Object)TerminologyNormalizer.Type.OBJECT) ? mapper.createObjectNode() : mapper.createArrayNode();
                JsonMappingValidator.validate(incomingNode, (JsonNode)outgoingNode, ackResolver, this.metaData, expectedType);
                if (ackResolver.getErrors().size() > 0) {
                    throw new BlufinClientException(ackResolver.getErrors(), ackResolver.getWarnings());
                }
                AckResolverThreadLocal.set((AckResolver)ackResolver);
                byte[] byteArray = mapper.writeValueAsBytes((Object)outgoingNode);
                this.modifiedInputStream = new ModifiedServletInputStream(byteArray);
            }
            catch (JsonProcessingException e) {
                String errorMessage = UtilsEnvironment.isLocal() || UtilsEnvironment.isDevelopment() ? MessageFormat.format("{0}. This message is only shown in {1}/{2}, in {3}/{4}/{5} you would see: {6}", e.getMessage(), Environment.LOCAL, Environment.DEVELOPMENT, Environment.SANDBOX, Environment.STAGING, Environment.PRODUCTION, ERROR_INVALID_JSON) : ERROR_INVALID_JSON;
                throw new BlufinClientException(AckError.JSON_ERROR.toString(new String[]{errorMessage}));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ServletInputStream getInputStream() {
        return this.modifiedInputStream;
    }
}

