/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.server.rest;

import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

public class ModifiedServletInputStream
extends ServletInputStream {
    private final byte[] modifiedByteArray;
    private int lastIndexRetrieved = -1;
    private ReadListener readListener = null;

    public ModifiedServletInputStream(byte[] modifiedByteArray) {
        this.modifiedByteArray = (byte[])modifiedByteArray.clone();
    }

    public boolean isFinished() {
        return this.lastIndexRetrieved == this.modifiedByteArray.length - 1;
    }

    public boolean isReady() {
        return this.isFinished();
    }

    public void setReadListener(ReadListener readListener) {
        this.readListener = readListener;
        if (!this.isFinished()) {
            try {
                readListener.onDataAvailable();
            }
            catch (IOException e) {
                readListener.onError((Throwable)e);
            }
        } else {
            try {
                readListener.onAllDataRead();
            }
            catch (IOException e) {
                readListener.onError((Throwable)e);
            }
        }
    }

    public int read() throws IOException {
        if (!this.isFinished()) {
            byte i = this.modifiedByteArray[this.lastIndexRetrieved + 1];
            ++this.lastIndexRetrieved;
            if (this.isFinished() && this.readListener != null) {
                try {
                    this.readListener.onAllDataRead();
                }
                catch (IOException ex) {
                    this.readListener.onError((Throwable)ex);
                    throw ex;
                }
            }
            return i;
        }
        return -1;
    }
}

