/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.server.rest;

import org.blufin.base.exceptions.BlufinAuthenticationException;
import org.blufin.base.exceptions.BlufinClientException;
import org.blufin.base.exceptions.BlufinForbiddenException;
import org.blufin.base.exceptions.BlufinNotFoundException;
import org.blufin.base.exceptions.BlufinNotImplementedException;
import org.blufin.sdk.response.ApiResponse;
import org.blufin.sdk.response.ApiResponseBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class RestExceptionHandler
extends ResponseEntityExceptionHandler {
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BlufinClientException.class})
    public ApiResponse badRequest(BlufinClientException e) {
        return ApiResponseBuilder.badRequest((BlufinClientException)e);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={BlufinAuthenticationException.class})
    public ApiResponse unauthorized() {
        return ApiResponseBuilder.unauthorized();
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={BlufinForbiddenException.class})
    public ApiResponse forbidden() {
        return ApiResponseBuilder.forbidden();
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={BlufinNotFoundException.class})
    public ApiResponse notFound(BlufinNotFoundException e) {
        return ApiResponseBuilder.notFound((BlufinNotFoundException)e);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Throwable.class})
    public ApiResponse serverError(Throwable e) {
        return ApiResponseBuilder.serverError((Throwable)e);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_IMPLEMENTED)
    @ExceptionHandler(value={BlufinNotImplementedException.class})
    public ApiResponse notImplemented(BlufinNotImplementedException e) {
        return ApiResponseBuilder.notImplemented((BlufinNotImplementedException)e);
    }

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, @Nullable Object body, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return new ResponseEntity((Object)ApiResponseBuilder.genericError((Throwable)ex, (HttpStatus)status), (MultiValueMap)headers, status);
    }
}

