/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.server.startup;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.blufin.base.enums.Environment;
import org.blufin.base.helper.Pair;
import org.blufin.base.utils.UtilsEnvironment;
import org.blufin.core.cloud.queue.MessageQueueConfig;
import org.blufin.core.server.aws.AWSInstanceDataResolver;
import org.blufin.core.server.config.BaseConfig;
import org.blufin.core.slack.SlackChannels;
import org.blufin.core.slack.SlackClient;
import org.blufin.jackson.Jackson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Primary;

@ComponentScan(value={"org.blufin.core.spring.core"})
public abstract class AbstractApplication {
    @Autowired
    BaseConfig baseConfig;

    protected void init() {
        UtilsEnvironment.initialize((Environment)this.baseConfig.getEnvironment());
        AWSInstanceDataResolver.initialize(this.baseConfig.getEnvironment());
        MessageQueueConfig.initialize((Pair<String, String>)Pair.of((Object)this.baseConfig.getMessageQueueHost(), (Object)this.baseConfig.getMessageQueueName()));
        SlackClient.initialize(new SlackChannels(this.baseConfig.getSlackLogURL(), this.baseConfig.getSlackErrorsURL()));
    }

    @Bean
    @Primary
    public ObjectMapper objectMapper() {
        return Jackson.getNonNullObjectMapper();
    }
}

