/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.server.startup;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.blufin.base.exceptions.BlufinServerException;
import org.blufin.base.helper.Pair;
import org.blufin.core.auth.core.AuthInitializationLevel;
import org.blufin.core.auth.core.AuthMethodInvoker;
import org.blufin.core.security.Encryptor;
import org.blufin.core.server.config.ApiConfig;
import org.blufin.core.server.db.CommonDataSource;
import org.blufin.core.server.db.ConfigDataSource;
import org.blufin.core.server.helper.AccountAwareDataSourceRefresher;
import org.blufin.core.server.rest.ModifiedRequest;
import org.blufin.core.server.rest.RestInterceptor;
import org.blufin.core.server.startup.AbstractApplication;
import org.blufin.sdk.base.ResourceData;
import org.blufin.sdk.embedded.base.EmbeddedSDK;
import org.blufin.sdk.enums.HttpMethod;
import org.blufin.sdk.service.BlufinApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ComponentScan(value={"org.blufin.core.auth.core", "org.blufin.core.server", "org.blufin.sdk.embedded.base"})
public abstract class ApiApplication<T extends BlufinApiService, R extends ResourceData>
extends AbstractApplication
implements ApplicationListener<ContextRefreshedEvent>,
WebMvcConfigurer,
Filter {
    @Autowired
    AuthMethodInvoker authMethodInvoker;
    @Autowired
    AccountAwareDataSourceRefresher accountAwareDataSourceRefresher;
    @Autowired
    ApiConfig apiConfig;
    @Autowired
    EmbeddedSDK embeddedSDK;
    @Autowired
    T autowiredSdk;
    @Autowired
    R autowiredResourceData;
    private static ResourceData resourceData;

    public void onApplicationEvent(ContextRefreshedEvent context) {
        try {
            this.init();
            ApiApplication.setResourceData(this.autowiredResourceData);
            Encryptor.initialize((Pair<String, String>)Pair.of((Object)this.apiConfig.getEncryptionKey(), (Object)this.apiConfig.getEncryptionIv()));
            ConfigDataSource.refresh(this.apiConfig.getConfigDatabase());
            CommonDataSource.refresh(this.apiConfig.getCommonDatabase());
            this.autowiredSdk.initialize(this.autowiredResourceData);
            this.embeddedSDK.initialize(this.autowiredResourceData);
            if (Arrays.asList(AuthInitializationLevel.INTERNAL_ACCOUNT_USER, AuthInitializationLevel.OAUTH_ACCOUNT_USER).contains((Object)this.apiConfig.getAuthorizationLevel())) {
                this.accountAwareDataSourceRefresher.setProjectName(this.baseConfig.getProjectName());
                this.accountAwareDataSourceRefresher.setAuthInitializationLevel(this.apiConfig.getAuthorizationLevel());
                this.accountAwareDataSourceRefresher.refresh();
            }
            this.authMethodInvoker.init(this.apiConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(MessageFormat.format("Application failed to start: {0}", e.getMessage()));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpMethod httpMethod = HttpMethod.valueOf((String)((HttpServletRequest)request).getMethod());
        switch (httpMethod) {
            case POST: 
            case PUT: 
            case PATCH: {
                request = new ModifiedRequest((HttpServletRequest)request);
                break;
            }
            case GET: 
            case DELETE: {
                break;
            }
            default: {
                throw new BlufinServerException(MessageFormat.format("Unsupported {0}: {1}", HttpMethod.class.getSimpleName(), httpMethod));
            }
        }
        chain.doFilter(request, response);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new RestInterceptor());
    }

    public static ResourceData getResourceData() {
        return resourceData;
    }

    private static void setResourceData(ResourceData resourceData) {
        ApiApplication.resourceData = resourceData;
    }
}

