/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.slack;

import org.blufin.base.interfaces.Initializable;
import org.blufin.core.http.HttpClient;
import org.blufin.core.http.HttpClientResponse;
import org.blufin.core.slack.SlackChannels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SlackClient
extends Initializable<SlackChannels> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlackClient.class);
    private static SlackClient instance = new SlackClient();
    private boolean testEnvironment = false;
    private String logUrl;
    private String errorUrl;

    private SlackClient() {
    }

    public static void initialize(SlackChannels slackChannels) {
        instance.initializeClass(slackChannels);
        SlackClient.instance.errorUrl = ((SlackChannels)instance.getInitializationData()).getErrorUrl();
    }

    public static void initializeForTest() {
        SlackClient.instance.testEnvironment = true;
    }

    public static void log(String message) {
        if (SlackClient.instance.testEnvironment) {
            System.out.println(message);
            return;
        }
        instance.postToSlack(message, instance.getLogUrl());
    }

    public static void error(String message) {
        if (SlackClient.instance.testEnvironment) {
            System.out.println(message);
            return;
        }
        instance.postToSlack(message, instance.getErrorUrl());
    }

    private void postToSlack(String message, String uri) {
        String payload = "{\"text\": \"" + message.replace("\"", "\\\"") + "\"}";
        HttpClientResponse response = HttpClient.postJsonString(uri, payload);
        if (response != null && response.getStatusCode() != 200) {
            LOGGER.error("SlackClient failed to post w/error: " + response.getStatusCode() + " - " + response.getStatusText() + " - " + response.getBody());
            LOGGER.error("SlackClient payload: " + payload);
        }
    }

    private String getLogUrl() {
        if (this.logUrl == null) {
            this.logUrl = ((SlackChannels)this.getInitializationData()).getLogUrl();
        }
        return this.logUrl;
    }

    private String getErrorUrl() {
        if (this.errorUrl == null) {
            this.errorUrl = ((SlackChannels)this.getInitializationData()).getErrorUrl();
        }
        return this.errorUrl;
    }
}

