/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.slack;

import java.util.Map;
import org.blufin.base.interfaces.Initializable;
import org.blufin.base.utils.UtilsLogger;
import org.blufin.core.http.HttpClient;
import org.blufin.core.http.HttpClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SlackClientDeprecated
extends Initializable<Map<String, String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlackClientDeprecated.class);
    public static final String DEBUG_URI = "DEBUG_URI";
    public static final String ERROR_URI = "ERROR_URI";
    public static final String HITS_URI = "HITS_URI";
    public static final String TICKER_URI = "TICKER_URI";
    private String slackDebugUri;
    private String slackErrorUri;
    private String slackHitsUri;
    private String slackTickerUri;
    private static SlackClientDeprecated instance = new SlackClientDeprecated();

    private SlackClientDeprecated() {
    }

    public static SlackClientDeprecated getInstance() {
        return instance;
    }

    public void postDebugAlert(String message) {
        try {
            this.postAlert(message, this.getSlackDebugUri(), "Debug", "slack");
        }
        catch (Exception e) {
            UtilsLogger.error((String)"Failed to post Slack \"Debug\" alert.", (Throwable)e);
        }
    }

    public void postErrorAlert(String message) {
        try {
            this.postAlert(message, this.getSlackErrorUri(), "Error", "slack");
        }
        catch (Exception e) {
            UtilsLogger.error((String)"Failed to post Slack \"Error\" alert.", (Throwable)e);
        }
    }

    public void postHitAlert(String message) {
        try {
            this.postAlert(message, this.getSlackHitsUri(), "Hit", "slack");
        }
        catch (Exception e) {
            UtilsLogger.error((String)"Failed to post Slack \"Hit\" alert.", (Throwable)e);
        }
    }

    public void postTickerAlert(String message) {
        try {
            this.postAlert(message, this.getSlackTickerUri(), "SlackTicker", "slack");
        }
        catch (Exception e) {
            UtilsLogger.error((String)"Failed to post Slack \"Ticker\" alert.", (Throwable)e);
        }
    }

    private void postAlert(String message, String uri, String botName, String botIcon) {
        String jsonString = "{\"username\": \"" + botName + "\", \"icon_emoji\": \"" + botIcon + "\", \"text\": \"" + message.replace("\"", "\\\"") + "\"}";
        HttpClientResponse response = HttpClient.postJsonString(uri, jsonString);
        if (response != null && response.getStatusCode() != 200) {
            LOGGER.error("SlackClientDeprecated failed to post: " + response.getStatusCode() + " - " + response.getStatusText() + " - " + response.getBody());
            LOGGER.error("JSON String:\n\n" + jsonString + "\n");
        }
    }

    private String getSlackDebugUri() {
        if (this.slackDebugUri == null) {
            this.slackDebugUri = (String)((Map)this.getInitializationData()).get(DEBUG_URI);
        }
        return this.slackDebugUri;
    }

    private String getSlackErrorUri() {
        if (this.slackErrorUri == null) {
            this.slackErrorUri = (String)((Map)this.getInitializationData()).get(ERROR_URI);
        }
        return this.slackErrorUri;
    }

    private String getSlackHitsUri() {
        if (this.slackHitsUri == null) {
            this.slackHitsUri = (String)((Map)this.getInitializationData()).get(HITS_URI);
        }
        return this.slackHitsUri;
    }

    private String getSlackTickerUri() {
        if (this.slackTickerUri == null) {
            this.slackTickerUri = (String)((Map)this.getInitializationData()).get(TICKER_URI);
        }
        return this.slackTickerUri;
    }
}

