/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.Charsets;
import org.blufin.base.utils.UtilsLogger;

public class UtilsFile {
    public static final String NEW_LINE = System.getProperty("line.separator");

    public static List<String> getFilesInDir(String directory) {
        ArrayList<String> files = new ArrayList<String>();
        try {
            File folder = new File(directory);
            File[] filesInFolder = folder.listFiles();
            if (filesInFolder != null) {
                for (File fileEntry : filesInFolder) {
                    if (fileEntry.isDirectory()) continue;
                    files.add(fileEntry.getName());
                }
                Collections.sort(files);
            }
        }
        catch (NullPointerException e) {
            UtilsLogger.error((String)("Directory '" + directory + "' not found in: '" + System.getProperty("user.dir") + "'"), (Throwable)e);
        }
        return files;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="In this case, it's cool :)")
    public static boolean writeStringToFile(String fullPathToFile, String content) {
        try {
            Path path = Paths.get(fullPathToFile, new String[0]);
            if (!UtilsFile.directoryExists(path.getParent().toString())) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            if (!UtilsFile.fileExists(fullPathToFile)) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(Paths.get(fullPathToFile, new String[0]), content.getBytes(Charsets.UTF_8), StandardOpenOption.WRITE);
            return true;
        }
        catch (Exception e) {
            UtilsLogger.error((String)("Something went wrong trying to write file: '" + fullPathToFile + "'"), (Throwable)e);
            return false;
        }
    }

    public static List<String> readLinesOfFileAsArray(String fullPathToFile) {
        ArrayList<String> lines = new ArrayList();
        try {
            lines = Files.readAllLines(Paths.get(fullPathToFile, new String[0]));
        }
        catch (IOException e) {
            UtilsLogger.error((String)("Something went wrong trying to read file as array of lines: " + fullPathToFile), (Throwable)e);
        }
        return lines;
    }

    public static String readLinesOfFileAsString(String fullPathToFile) {
        StringBuilder contentBuilder = new StringBuilder();
        try {
            for (String line : Files.readAllLines(Paths.get(fullPathToFile, new String[0]))) {
                contentBuilder.append(line).append(NEW_LINE);
            }
        }
        catch (IOException e) {
            UtilsLogger.error((String)("Something went wrong trying to read file as string: " + fullPathToFile), (Throwable)e);
        }
        return contentBuilder.toString();
    }

    public static boolean createDirectory(String fullPathToDirectory) {
        boolean result = false;
        try {
            result = new File(fullPathToDirectory).mkdirs();
            if (!result) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            UtilsLogger.error((String)("Failed to create directory: " + fullPathToDirectory));
        }
        return result;
    }

    public static boolean deleteDirectory(String fullPathToDirectory) {
        boolean result = false;
        try {
            File directory = new File(fullPathToDirectory);
            if (!directory.isDirectory()) {
                throw new Exception("Cannot delete directory because not a directory: " + fullPathToDirectory);
            }
            result = directory.delete();
            if (!result) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            UtilsLogger.error((String)("Failed to delete directory: " + fullPathToDirectory), (Throwable)e);
        }
        return result;
    }

    public static boolean fileExists(String fullPathToFile) {
        File file = new File(fullPathToFile);
        return file.exists() && !file.isDirectory();
    }

    public static boolean directoryExists(String fullPathToFile) {
        File file = new File(fullPathToFile);
        return file.exists() && file.isDirectory();
    }
}

