/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class UtilsGenerics {
    private static <T> Class<T> determineClass(Class<? super T> bound, Type candidate) {
        Class cls;
        if (candidate instanceof Class && bound.isAssignableFrom(cls = (Class)candidate)) {
            return cls;
        }
        return null;
    }

    public static <T> Class<T> getTypeParameter(Class<?> clazz, Class<? super T> bound) {
        Type type = clazz;
        while (type instanceof Class) {
            type = type.getGenericSuperclass();
        }
        if (type instanceof ParameterizedType) {
            for (Type param : ((ParameterizedType)type).getActualTypeArguments()) {
                if (param instanceof Class) {
                    Class<? super T> cls = UtilsGenerics.determineClass(bound, param);
                    if (cls == null) continue;
                    return cls;
                }
                if (!(param instanceof TypeVariable)) continue;
                for (Type paramBound : ((TypeVariable)param).getBounds()) {
                    Class<? super T> cls;
                    if (!(paramBound instanceof Class) || (cls = UtilsGenerics.determineClass(bound, paramBound)) == null) continue;
                    return cls;
                }
            }
        }
        throw new IllegalStateException("Cannot reliably determine type parameterization for: " + clazz.getName());
    }

    public static Class<?> getTypeParameter(Class<?> clazz) {
        return UtilsGenerics.getTypeParameter(clazz, Object.class);
    }
}

