/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.activation.UnsupportedDataTypeException;
import org.blufin.base.enums.Country;
import org.blufin.base.enums.Money;
import org.blufin.base.utils.UtilsLogger;
import org.blufin.base.utils.UtilsString;

public class UtilsMoney {
    private static DecimalFormat decimalFormat = new DecimalFormat("#.00");

    public static String displayWithCurrencySymbol(Country locale, String threeDigitCurrencyCode, String amount) {
        if (amount.equals("")) {
            amount = "0.00";
        }
        return UtilsMoney.displayWithCurrencySymbol(locale, threeDigitCurrencyCode, new BigDecimal(Double.parseDouble(amount)));
    }

    public static String displayWithCurrencySymbol(Country locale, String threeDigitCurrencyCode, double amount) {
        return UtilsMoney.displayWithCurrencySymbol(locale, threeDigitCurrencyCode, new BigDecimal(amount));
    }

    public static String displayWithCurrencySymbol(Country locale, String threeDigitCurrencyCode, int amount) {
        return UtilsMoney.displayWithCurrencySymbol(locale, threeDigitCurrencyCode, new BigDecimal(amount));
    }

    public static String displayWithCurrencySymbol(Country locale, String threeDigitCurrencyCode, BigDecimal amount) {
        boolean isNegative = false;
        BigDecimal absoluteAmount = new BigDecimal(String.valueOf(amount)).abs();
        if (amount.compareTo(absoluteAmount) != 0) {
            amount = absoluteAmount;
            isNegative = true;
        }
        StringBuilder output = new StringBuilder();
        Money money = UtilsMoney.getMoneyFromThreeLetterCode(threeDigitCurrencyCode);
        String amountFormatted = UtilsMoney.getAmountFormatted(amount);
        if (locale.getDefaultCurrency().equals((Object)money)) {
            if (money.symbolAsLocalComesBeforeAmount()) {
                output.append(money.getSymbolAsLocal());
            } else {
                output.append(amountFormatted);
            }
            if (money.hasSpaceBetweenSymbolAsLocalAndAmount()) {
                output.append(" ");
            }
            if (money.symbolAsLocalComesBeforeAmount()) {
                output.append(amountFormatted);
            } else {
                output.append(money.getSymbolAsLocal());
            }
        } else {
            if (money.symbolAsForeignComesBeforeAmount()) {
                output.append(money.getSymbolAsForeign());
            } else {
                output.append(amountFormatted);
            }
            if (money.hasSpaceBetweenSymbolAsForeignAndAmount()) {
                output.append(" ");
            }
            if (money.symbolAsForeignComesBeforeAmount()) {
                output.append(amountFormatted);
            } else {
                output.append(money.getSymbolAsForeign());
            }
        }
        if (isNegative) {
            return "-" + output.toString();
        }
        return output.toString();
    }

    public static Money getMoneyFromThreeLetterCode(String threeLetterCode) {
        try {
            switch (threeLetterCode.trim().toUpperCase()) {
                case "AUD": {
                    return Money.AUD;
                }
                case "CAD": {
                    return Money.CAD;
                }
                case "CHF": {
                    return Money.CHF;
                }
                case "EUR": {
                    return Money.EUR;
                }
                case "GBP": {
                    return Money.GBP;
                }
                case "PLN": {
                    return Money.PLN;
                }
                case "USD": {
                    return Money.USD;
                }
            }
            throw new UnsupportedDataTypeException();
        }
        catch (Exception e) {
            UtilsLogger.error((String)("Currency not supported: " + threeLetterCode), (Throwable)e);
            return null;
        }
    }

    public static BigDecimal getBigDecimalFromCurrencyString(String formattedString) {
        String cleanedString = formattedString.replaceAll("[^0-9.]", "");
        int decimalPlaces = UtilsString.numberOfOccurrences((String)cleanedString, (String)".");
        if (decimalPlaces == 0) {
            if (cleanedString.equals("")) {
                cleanedString = "0.00";
            }
            return new BigDecimal(UtilsMoney.formatWithTwoDecimalPlaces(new BigDecimal(cleanedString)));
        }
        if (decimalPlaces == 1) {
            return new BigDecimal(cleanedString);
        }
        throw new IllegalArgumentException(MessageFormat.format("Expected exactly 0 or 1 occurrence(es) of a period, instead got: {0}", decimalPlaces));
    }

    public static String formatWithTwoDecimalPlaces(BigDecimal amount) {
        return decimalFormat.format(amount.setScale(2, RoundingMode.HALF_UP));
    }

    private static String getAmountFormatted(BigDecimal amount) {
        String amountFormatted = UtilsMoney.formatWithTwoDecimalPlaces(amount);
        if (amountFormatted.equals(".00")) {
            amountFormatted = "0.00";
        }
        String[] amountFormattedSplit = amountFormatted.split("\\.");
        return NumberFormat.getNumberInstance(Locale.US).format(Integer.parseInt(amountFormattedSplit[0])) + "." + amountFormattedSplit[1];
    }
}

