/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.util.ReflectionUtils;

public class UtilsObject {
    public static final String DEFAULT_SPACING = "  ";
    public static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");

    public static final String dump(Object instance) {
        StringBuilder result = new StringBuilder();
        result.append(instance.getClass().getName());
        result.append(instance.getClass().getSimpleName() + " [");
        result.append(DEFAULT_LINE_SEPARATOR);
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(instance.getClass());
        ArrayList<String> methodList = new ArrayList<String>();
        for (Method method : methods) {
            String methodName = method.getName();
            if (!methodName.substring(0, 3).equals("get") || methodName.equals("getClass")) continue;
            methodList.add(method.getName());
        }
        Collections.sort(methodList);
        for (String method : methodList) {
            result.append(DEFAULT_SPACING);
            result.append(method.substring(3, 4).toLowerCase() + method.substring(4));
            result.append(": ");
            try {
                result.append(instance.getClass().getMethod(method, new Class[0]).invoke(instance, new Object[0]));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                result.append(e.getMessage());
            }
            result.append(DEFAULT_LINE_SEPARATOR);
        }
        result.append("]");
        return result.toString();
    }
}

