/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.utils;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.blufin.base.utils.UtilsLogger;

public class UtilsSoap {
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();

    public static XMLStreamReader getXMLStream(String rawSoapXML) {
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(rawSoapXML.getBytes(StandardCharsets.UTF_8));
            return xmlInputFactory.createXMLStreamReader(byteStream);
        }
        catch (XMLStreamException e) {
            UtilsLogger.error((String)"Failed to get XMLStreamReader from SOAP XML String.", (String)rawSoapXML, (Throwable)e);
            return null;
        }
    }

    public static XMLStreamReader getXMLStreamForStartElement(String rawSoapXML, String nodeName) {
        try {
            XMLStreamReader xmlStream = UtilsSoap.getXMLStream(rawSoapXML);
            if (xmlStream != null) {
                while (xmlStream.hasNext()) {
                    if (xmlStream.next() != 1 || !nodeName.equals(xmlStream.getLocalName())) continue;
                    return xmlStream;
                }
            }
        }
        catch (XMLStreamException e) {
            UtilsLogger.error((String)("Failed to find node '" + nodeName + "' in SOAP XML String -- returned NULL instead of XMLStreamReader."), (String)rawSoapXML, (Throwable)e);
        }
        return null;
    }

    public static List<String> getValueForNodeName(String rawSoapXML, String nodeName) {
        ArrayList<String> valuesForNodeNames = new ArrayList<String>();
        try {
            XMLStreamReader xmlStream = UtilsSoap.getXMLStream(rawSoapXML);
            if (xmlStream != null) {
                while (xmlStream.hasNext()) {
                    if (xmlStream.next() != 1 || !nodeName.equals(xmlStream.getLocalName())) continue;
                    xmlStream.next();
                    valuesForNodeNames.add(xmlStream.getText());
                }
            }
        }
        catch (Exception e) {
            UtilsLogger.error((String)("Failed to get value(s) for node name: " + nodeName), (String)rawSoapXML, (Throwable)e);
        }
        return valuesForNodeNames;
    }
}

