/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.core.utils;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.blufin.base.utils.UtilsLogger;

public class UtilsValidation {
    public static <T> ArrayList<String> validatePropertiesAreNotNull(T object) {
        ArrayList<String> nullProperties = new ArrayList<String>();
        for (Field field : object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object value = field.get(object);
                if (value != null) continue;
                nullProperties.add(field.getName());
            }
            catch (IllegalAccessException e) {
                UtilsLogger.error((String)MessageFormat.format("Failed to iterate property values of {0}.", object.getClass().getName()), (Throwable)e);
            }
        }
        return nullProperties;
    }
}

