
package org.blufin.sdk.base;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
public abstract class AbstractMapperEmbedded<DTO extends PersistentDtoEmbedded> {
    public abstract DTO map(Object object) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException;
    protected static <T> T mapObject(Object object, String method, AbstractMapperEmbedded mapper) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object data = object.getClass().getMethod(method).invoke(object);
        return (data == null) ? null : (T) mapper.map(data);
    }
    protected static <T, S> List<T> mapList(Object object, String method, AbstractMapperEmbedded mapper) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        List<T> list = new ArrayList<>();
        for (S source : (List<S>) object.getClass().getMethod(method).invoke(object)) {
            if (source != null) {
                list.add((T) mapper.map(source));
            }
        }
        return list;
    }
}
