
package org.blufin.sdk.base;
import org.blufin.base.exceptions.BlufinServerException;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.response.AckResolver;
import org.blufin.sdk.rest.PatchOperation;
import java.sql.Connection;
import java.util.List;
public interface AbstractValidatorInterface<D extends PersistentDto> {
    void validatePost(Connection connection, List<D> dto, AckResolver ackResolver) throws BlufinServerException;
    void validatePut(Connection connection, List<D> dto, AckResolver ackResolver) throws BlufinServerException;
    void validatePatch(Connection connection, List<PatchOperation> patch, AckResolver ackResolver);
    void validateDelete(Connection connection, IdSet ids, AckResolver ackResolver) throws BlufinServerException;
}
