
package org.blufin.sdk.embedded.base;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.sdk.base.ResourceData;
import org.blufin.sdk.embedded.service.*;
import org.blufin.sdk.service.BlufinApiService;
import org.blufin.sdk.service.credentials.ApiCredentialsHttp;
import org.blufin.sdk.service.credentials.ApiCredentialsInternal;
import org.springframework.stereotype.Service;
@Service
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedSDK extends BlufinApiService {
    public void initialize(ResourceData resourceLocator) {
        initializeParent(new ApiCredentialsInternal(resourceLocator));
    }
    public void initialize(String authorizationHeader, String apiUri) {
        initializeParent(new ApiCredentialsHttp(authorizationHeader, apiUri));
    }
    public EmbeddedClientService getEmbeddedClientService() {
        return new EmbeddedClientService(getApiCredentials());
    }
    public EmbeddedDbService getEmbeddedDbService() {
        return new EmbeddedDbService(getApiCredentials());
    }
    public EmbeddedDbConfigurationService getEmbeddedDbConfigurationService() {
        return new EmbeddedDbConfigurationService(getApiCredentials());
    }
    public EmbeddedDbConfigurationPropertyService getEmbeddedDbConfigurationPropertyService() {
        return new EmbeddedDbConfigurationPropertyService(getApiCredentials());
    }
    public EmbeddedProfileService getEmbeddedProfileService() {
        return new EmbeddedProfileService(getApiCredentials());
    }
    public EmbeddedProfileApiService getEmbeddedProfileApiService() {
        return new EmbeddedProfileApiService(getApiCredentials());
    }
    public EmbeddedProfileCronService getEmbeddedProfileCronService() {
        return new EmbeddedProfileCronService(getApiCredentials());
    }
    public EmbeddedProfileWorkerService getEmbeddedProfileWorkerService() {
        return new EmbeddedProfileWorkerService(getApiCredentials());
    }
    public EmbeddedProjectService getEmbeddedProjectService() {
        return new EmbeddedProjectService(getApiCredentials());
    }
    public EmbeddedAccountService getEmbeddedAccountService() {
        return new EmbeddedAccountService(getApiCredentials());
    }
    public EmbeddedAccountPermissionService getEmbeddedAccountPermissionService() {
        return new EmbeddedAccountPermissionService(getApiCredentials());
    }
    public EmbeddedCronService getEmbeddedCronService() {
        return new EmbeddedCronService(getApiCredentials());
    }
    public EmbeddedThirdPartyApplicationService getEmbeddedThirdPartyApplicationService() {
        return new EmbeddedThirdPartyApplicationService(getApiCredentials());
    }
    public EmbeddedThirdPartyApplicationPermissionService getEmbeddedThirdPartyApplicationPermissionService() {
        return new EmbeddedThirdPartyApplicationPermissionService(getApiCredentials());
    }
    public EmbeddedThirdPartyDeveloperService getEmbeddedThirdPartyDeveloperService() {
        return new EmbeddedThirdPartyDeveloperService(getApiCredentials());
    }
    public EmbeddedUserService getEmbeddedUserService() {
        return new EmbeddedUserService(getApiCredentials());
    }
    public EmbeddedUserPermissionService getEmbeddedUserPermissionService() {
        return new EmbeddedUserPermissionService(getApiCredentials());
    }
}
