
package org.blufin.sdk.embedded.dto.app;
import lombok.Data;
import org.blufin.base.annotations.Embedded;
import org.blufin.base.annotations.Implements;
import org.blufin.base.annotations.ImplementsObject;
import org.blufin.base.annotations.ParsedByRuby;
import org.blufin.base.annotations.helper.Relation;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.DataTypeFlag;
import org.blufin.base.enums.TimeZone;
import org.blufin.sdk.base.PersistentDtoEmbedded;
import java.time.LocalDate;
@Data
@ParsedByRuby
@Embedded("user")
public class EmbeddedUser extends PersistentDtoEmbedded {
    @Implements(value = DataType.INT_AUTO, flags = {DataTypeFlag.PRIMARY_KEY})
    private Integer id;
    @Implements(value = DataType.BOOLEAN, extra = "false")
    private Boolean archived;
    @Implements(value = DataType.BOOLEAN, extra = "false")
    private Boolean suspended;
    @Implements(value = DataType.VARCHAR, extra = "255", flags = {DataTypeFlag.INDEX, DataTypeFlag.UNIQUE})
    private String email;
    @Implements(value = DataType.VARCHAR, extra = "255", flags = {DataTypeFlag.INDEX})
    private String passwordHash;
    @Implements(DataType.DATE)
    private LocalDate createdDate;
    @Implements(DataType.ENUM_SYSTEM)
    private TimeZone timeZone;
    @ImplementsObject(value = "user_permission", relation = Relation.ONE_TO_ONE)
    private EmbeddedUserPermission userPermission;
}
